/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.config;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.core.RepositoryMetadata;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreCustomRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListPagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStorePagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.support.EclipseStoreRepositoryFactoryBean;

public class EclipseStoreRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreRepositoryConfigurationExtension.class);

    @Nonnull
    public String getModuleName() {
        return "EclipseStoreDatastore";
    }

    @Nonnull
    public String getModulePrefix() {
        return this.getModuleIdentifier();
    }

    @Nonnull
    public String getRepositoryFactoryBeanClassName() {
        return EclipseStoreRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        Object object = config.getSource();
        if (object instanceof AnnotationMetadata) {
            AnnotationMetadata classMetadata = (AnnotationMetadata)object;
            try {
                Class<?> possibleConfigurationClass = Class.forName(classMetadata.getClassName());
                if (EclipseStoreClientConfiguration.class.isAssignableFrom(possibleConfigurationClass)) {
                    builder.addPropertyValue("configurationClass", possibleConfigurationClass);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Could not use {} as configuration.", (Object)classMetadata.getClassName());
            }
        }
    }

    @Nonnull
    public String getModuleIdentifier() {
        return "EclipseStore";
    }

    @Nonnull
    public Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptyList();
    }

    @Nonnull
    protected Collection<Class<?>> getIdentifyingTypes() {
        return List.of(EclipseStoreRepository.class, EclipseStoreCustomRepository.class, EclipseStorePagingAndSortingRepositoryRepository.class, EclipseStoreListPagingAndSortingRepositoryRepository.class, EclipseStoreCrudRepository.class, EclipseStoreListCrudRepository.class);
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return super.useRepositoryConfiguration(metadata);
    }
}

