/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.config;

import org.eclipse.store.integrations.spring.boot.types.configuration.ConfigurationPair;
import org.eclipse.store.integrations.spring.boot.types.configuration.EclipseStoreProperties;
import org.eclipse.store.integrations.spring.boot.types.factories.EmbeddedStorageFoundationFactory;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreStorageFoundationProvider;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransactionManager;

@Configuration(proxyBeanMethods=false)
@ComponentScan(value={"org.eclipse.store.integrations.spring.boot.types", "software.xdev.spring.data.eclipse.store.importer"})
public abstract class EclipseStoreClientConfiguration
implements EclipseStoreStorageFoundationProvider {
    private final EclipseStoreProperties defaultEclipseStoreProperties;
    private final EmbeddedStorageFoundationFactory defaultEclipseStoreProvider;
    private EclipseStoreStorage storageInstance;
    private EclipseStoreTransactionManager transactionManager;

    @Autowired
    protected EclipseStoreClientConfiguration(EclipseStoreProperties defaultEclipseStoreProperties, EmbeddedStorageFoundationFactory defaultEclipseStoreProvider) {
        this.defaultEclipseStoreProperties = defaultEclipseStoreProperties;
        this.defaultEclipseStoreProperties.setAutoStart(false);
        this.defaultEclipseStoreProvider = defaultEclipseStoreProvider;
    }

    public EclipseStoreProperties getEclipseStoreProperties() {
        return this.defaultEclipseStoreProperties;
    }

    public EmbeddedStorageFoundationFactory getStoreProvider() {
        return this.defaultEclipseStoreProvider;
    }

    @Override
    public EmbeddedStorageFoundation<?> createEmbeddedStorageFoundation() {
        return this.getStoreProvider().createStorageFoundation(this.getEclipseStoreProperties(), new ConfigurationPair[0]);
    }

    public EclipseStoreStorage getStorageInstance() {
        if (this.storageInstance == null) {
            this.storageInstance = new EclipseStoreStorage(this);
        }
        return this.storageInstance;
    }

    public PlatformTransactionManager transactionManager(ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        EclipseStoreTransactionManager transactionManager = this.getTransactionManagerInstance();
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((TransactionManager)transactionManager));
        return transactionManager;
    }

    public EclipseStoreTransactionManager getTransactionManagerInstance() {
        if (this.transactionManager == null) {
            this.transactionManager = new EclipseStoreTransactionManager();
        }
        return this.transactionManager;
    }
}

