/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.serializer.persistence.binary.jdk17.java.util.BinaryHandlerImmutableCollectionsList12;
import org.eclipse.serializer.persistence.binary.jdk17.java.util.BinaryHandlerImmutableCollectionsSet12;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.persistence.types.Storer;
import org.eclipse.serializer.reference.ObjectSwizzling;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.eclipse.store.storage.types.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.core.IdentitySet;
import software.xdev.spring.data.eclipse.store.exceptions.AlreadyRegisteredException;
import software.xdev.spring.data.eclipse.store.repository.EntityListProvider;
import software.xdev.spring.data.eclipse.store.repository.EntitySetCollector;
import software.xdev.spring.data.eclipse.store.repository.IdManagerProvider;
import software.xdev.spring.data.eclipse.store.repository.PersistableChecker;
import software.xdev.spring.data.eclipse.store.repository.RelayedPersistenceChecker;
import software.xdev.spring.data.eclipse.store.repository.Root;
import software.xdev.spring.data.eclipse.store.repository.WorkingCopyRegistry;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreStorageFoundationProvider;
import software.xdev.spring.data.eclipse.store.repository.support.SimpleEclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.support.concurrency.ReadWriteLock;
import software.xdev.spring.data.eclipse.store.repository.support.concurrency.ReentrantJavaReadWriteLock;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdManager;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdSetter;
import software.xdev.spring.data.eclipse.store.repository.support.reposyncer.RepositorySynchronizer;
import software.xdev.spring.data.eclipse.store.repository.support.reposyncer.SimpleRepositorySynchronizer;

public class EclipseStoreStorage
implements EntityListProvider,
IdManagerProvider,
PersistableChecker,
ObjectSwizzling {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreStorage.class);
    private final Map<Class<?>, SimpleEclipseStoreRepository<?, ?>> entityClassToRepository = new HashMap();
    private final Map<Class<?>, IdManager<?, ?>> idManagers = new ConcurrentHashMap();
    private final EclipseStoreStorageFoundationProvider foundationProvider;
    private EntitySetCollector entitySetCollector;
    private PersistableChecker persistenceChecker;
    private StorageManager storageManager;
    private Root root;
    private final WorkingCopyRegistry registry = new WorkingCopyRegistry();
    private final ReadWriteLock readWriteLock = new ReentrantJavaReadWriteLock();
    private RepositorySynchronizer repositorySynchronizer;

    public EclipseStoreStorage(EclipseStoreClientConfiguration storeConfiguration) {
        this.foundationProvider = storeConfiguration;
    }

    private StorageManager getInstanceOfStorageManager() {
        this.ensureEntitiesInRoot();
        return this.storageManager;
    }

    public WorkingCopyRegistry getRegistry() {
        return this.registry;
    }

    private synchronized void ensureEntitiesInRoot() {
        if (this.storageManager == null) {
            LOG.info("Starting storage...");
            this.root = new Root();
            EmbeddedStorageFoundation<?> embeddedStorageFoundation = this.foundationProvider.createEmbeddedStorageFoundation();
            embeddedStorageFoundation.registerTypeHandler((PersistenceTypeHandler)BinaryHandlerImmutableCollectionsSet12.New());
            embeddedStorageFoundation.registerTypeHandler((PersistenceTypeHandler)BinaryHandlerImmutableCollectionsList12.New());
            this.storageManager = embeddedStorageFoundation.start((Object)this.root);
            this.persistenceChecker = new RelayedPersistenceChecker(embeddedStorageFoundation);
            this.initRoot();
            Integer entitySum = this.root.getEntityLists().values().stream().map(IdentitySet::size).reduce(0, Integer::sum);
            LOG.info("Storage started with {} entity lists and {} entities.", (Object)this.root.getEntityLists().size(), (Object)entitySum);
        }
    }

    public <T> SimpleEclipseStoreRepository<T, ?> getRepository(Class<T> entityClass) {
        return this.entityClassToRepository.get(entityClass);
    }

    private void initRoot() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing entity lists...");
        }
        this.repositorySynchronizer = new SimpleRepositorySynchronizer(this.root);
        boolean entityListMustGetStored = false;
        for (Class<?> entityClass : this.entityClassToRepository.keySet()) {
            if (this.root.getEntityList(entityClass) != null) continue;
            this.root.createNewEntityList(entityClass);
            entityListMustGetStored = true;
        }
        if (entityListMustGetStored) {
            this.storageManager.store(this.root.getEntityLists());
        }
        this.entitySetCollector = new EntitySetCollector(this.root::getEntityList, this.entityClassToRepository.keySet());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done initializing entity lists.");
        }
    }

    public synchronized <T> void registerEntity(Class<T> classToRegister, SimpleEclipseStoreRepository<T, ?> repository) {
        if (this.entityClassToRepository.containsKey(classToRegister)) {
            throw new AlreadyRegisteredException(classToRegister.getSimpleName());
        }
        this.entityClassToRepository.put(classToRegister, repository);
        if (this.storageManager != null) {
            this.stop();
        }
    }

    @Override
    public <T> IdentitySet<T> getEntityList(Class<T> clazz) {
        this.ensureEntitiesInRoot();
        return this.readWriteLock.read(() -> this.root.getEntityList(clazz));
    }

    @Override
    public <T> long getEntityCount(Class<T> clazz) {
        this.ensureEntitiesInRoot();
        return this.readWriteLock.read(() -> {
            IdentitySet entityList = this.root.getEntityList(clazz);
            return entityList == null ? 0 : entityList.size();
        }).intValue();
    }

    public <T> void store(Collection<Object> nonEntitiesToStore, Class<T> clazz, Iterable<T> entitiesToStore) {
        this.ensureEntitiesInRoot();
        this.readWriteLock.write(() -> {
            Collection<Object> entitiesAndPossiblyNonEntitiesToStore = this.collectRootEntitiesToStore(clazz, entitiesToStore);
            entitiesAndPossiblyNonEntitiesToStore.addAll(nonEntitiesToStore);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Collected {} objects store in total.", (Object)entitiesAndPossiblyNonEntitiesToStore.size());
            }
            Storer storer = this.storageManager.createLazyStorer();
            storer.storeAll(entitiesAndPossiblyNonEntitiesToStore);
            storer.commit();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Done storing {} entities...", (Object)entitiesAndPossiblyNonEntitiesToStore.size());
            }
        });
    }

    private <T> Collection<Object> collectRootEntitiesToStore(Class<T> clazz, Iterable<T> entitiesToStore) {
        List<IdentitySet<Object>> entityLists = this.entitySetCollector.getRelatedIdentitySets(clazz);
        ArrayList<Object> objectsToStore = new ArrayList<Object>();
        for (Object entityToStore : entitiesToStore) {
            entityLists.forEach(relatedIdentitySet -> {
                if (!relatedIdentitySet.contains(entityToStore)) {
                    relatedIdentitySet.add(entityToStore);
                    objectsToStore.add(relatedIdentitySet.getInternalMap());
                }
            });
            objectsToStore.add(entityToStore);
            this.repositorySynchronizer.syncAndReturnChangedObjectLists(entityToStore).forEach(changedEntityList -> objectsToStore.add(changedEntityList.getInternalMap()));
        }
        return objectsToStore;
    }

    public <T> void delete(Class<T> clazz, T objectToRemove) {
        this.ensureEntitiesInRoot();
        this.readWriteLock.write(() -> {
            List<IdentitySet<Object>> entityLists = this.entitySetCollector.getRelatedIdentitySets(clazz);
            entityLists.forEach(entityList -> {
                entityList.remove(objectToRemove);
                this.storageManager.store(entityList.getInternalMap());
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted single entity of class {}.", (Object)clazz.getSimpleName());
            }
        });
    }

    public <T> void deleteAll(Class<T> clazz) {
        this.ensureEntitiesInRoot();
        this.readWriteLock.write(() -> {
            IdentitySet entities = this.root.getEntityList(clazz);
            int oldSize = entities.size();
            List entitiesToRemove = entities.stream().toList();
            List<IdentitySet<Object>> entityLists = this.entitySetCollector.getRelatedIdentitySets(clazz);
            entityLists.forEach(entityList -> {
                entityList.removeAll(entitiesToRemove);
                this.storageManager.store(entityList.getInternalMap());
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted {} entities of class {}.", (Object)oldSize, (Object)clazz.getSimpleName());
            }
        });
    }

    public void clearData() {
        this.ensureEntitiesInRoot();
        this.readWriteLock.write(() -> {
            this.root = new Root();
            StorageManager instanceOfstorageManager = this.getInstanceOfStorageManager();
            this.initRoot();
            instanceOfstorageManager.setRoot((Object)this.root);
            instanceOfstorageManager.storeRoot();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleared all entities.");
            }
        });
    }

    public void start() {
        this.ensureEntitiesInRoot();
    }

    public synchronized void stop() {
        this.readWriteLock.write(() -> {
            LOG.info("Stopping storage...");
            if (this.storageManager != null) {
                this.storageManager.shutdown();
                this.storageManager = null;
                this.root = null;
                this.registry.reset();
                this.idManagers.clear();
                LOG.info("Stopped storage.");
            } else {
                LOG.info("No storage is running. Nothing to stop.");
            }
        });
    }

    @Override
    public <T, ID> IdManager<T, ID> ensureIdManager(Class<T> domainClass) {
        this.ensureEntitiesInRoot();
        return this.idManagers.computeIfAbsent(domainClass, clazz -> new IdManager(domainClass, IdSetter.createIdSetter(clazz, id -> this.setLastId((Class<?>)clazz, id), () -> this.getLastId((Class<?>)clazz)), this));
    }

    public Object getLastId(Class<?> entityClass) {
        return this.readWriteLock.read(() -> this.root.getLastId(entityClass));
    }

    public void setLastId(Class<?> entityClass, Object lastId) {
        this.readWriteLock.write(() -> {
            this.root.setLastId(entityClass, lastId);
            this.storageManager.store(this.root.getLastIds());
        });
    }

    @Override
    public boolean isPersistable(Class<?> clazz) {
        this.ensureEntitiesInRoot();
        return this.persistenceChecker.isPersistable(clazz);
    }

    public Object getObject(long objectId) {
        this.ensureEntitiesInRoot();
        return this.storageManager.getObject(objectId);
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

