/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.transactions;

import java.util.ArrayList;
import org.springframework.transaction.TransactionSystemException;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransaction;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransactionAction;

public class EclipseStoreExistingTransactionObject
implements EclipseStoreTransaction {
    private ArrayList<EclipseStoreTransactionAction> actions;

    public synchronized void startTransaction() {
        if (this.actions != null) {
            throw new TransactionSystemException("Transaction is already started but it should start again. This is not allowed!");
        }
        this.actions = new ArrayList();
    }

    public synchronized void rollbackTransaction() {
        this.actions = null;
    }

    public synchronized void commitTransaction() {
        if (this.actions == null) {
            throw new TransactionSystemException("Transaction is not started but actions should be executed. This is not allowed!");
        }
        this.actions.forEach(EclipseStoreTransactionAction::execute);
        this.actions = null;
    }

    @Override
    public synchronized void addAction(EclipseStoreTransactionAction action) {
        if (action == null) {
            return;
        }
        if (this.actions == null) {
            throw new TransactionSystemException("Transaction is not started but action should be added. This is not allowed!");
        }
        this.actions.add(action);
    }
}

