/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.auto;

import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.IdFinder;

public abstract class AbstractAutoIdFinder<ID>
implements IdFinder<ID> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAutoIdFinder.class);
    final Supplier<ID> lastIdGetter;

    protected AbstractAutoIdFinder(Supplier<ID> lastIdGetter) {
        this.lastIdGetter = Objects.requireNonNull(lastIdGetter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("New AutoIdFinder created. Starting ID: {}", this.lastIdGetter.get());
        }
    }

    @Override
    public ID findId() {
        ID nextId = this.getNext(this.lastIdGetter.get());
        if (LOG.isDebugEnabled()) {
            LOG.debug("New Id created: {}", nextId);
        }
        return nextId;
    }

    protected abstract ID getNext(ID var1);
}

