/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.exceptions.NoIdFieldFoundException;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListPagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStorePagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreQueryByExampleExecutor;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.query.by.example.EclipseStoreFetchableFluentQuery;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.CriteriaByExample;
import software.xdev.spring.data.eclipse.store.repository.query.executors.CountQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.ExistsQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.ListQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.PageableQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.SingleOptionalQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.IdFieldFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopierResult;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransaction;
import software.xdev.spring.data.eclipse.store.transactions.EclipseStoreTransactionManager;

public class SimpleEclipseStoreRepository<T, ID>
implements EclipseStoreRepository<T, ID>,
EclipseStorePagingAndSortingRepositoryRepository<T, ID>,
EclipseStoreListPagingAndSortingRepositoryRepository<T, ID>,
EclipseStoreCrudRepository<T, ID>,
EclipseStoreListCrudRepository<T, ID>,
EclipseStoreQueryByExampleExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleEclipseStoreRepository.class);
    private final EclipseStoreStorage storage;
    private final Class<T> domainClass;
    private final WorkingCopier<T> copier;
    private final EclipseStoreTransactionManager transactionManager;
    private Field idField;

    public SimpleEclipseStoreRepository(EclipseStoreStorage storage, WorkingCopier<T> copier, Class<T> domainClass, EclipseStoreTransactionManager transactionManager) {
        this.storage = storage;
        this.domainClass = domainClass;
        this.storage.registerEntity(domainClass, this);
        this.copier = copier;
        this.transactionManager = transactionManager;
    }

    public Field getIdField() {
        if (this.idField == null) {
            Optional<Field> foundIdField = IdFieldFinder.findIdField(this.domainClass);
            if (foundIdField.isEmpty()) {
                throw new NoIdFieldFoundException(String.format("Could not find id field in class %s", this.domainClass.getSimpleName()));
            }
            this.idField = foundIdField.get();
        }
        return this.idField;
    }

    public <S extends T> List<S> saveBulk(Collection<S> entities) {
        EclipseStoreTransaction transaction = this.transactionManager.getTransaction();
        transaction.addAction(() -> this.uncachedStore(entities));
        return (List)entities;
    }

    private <S extends T> void uncachedStore(Collection<S> entities) {
        this.storage.getReadWriteLock().write(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving {} entities...", (Object)entities.size());
            }
            List<WorkingCopierResult> results = this.checkEntityForNull(entities).parallelStream().map(this.copier::mergeBack).toList();
            Set<Object> nonEntitiesToStore = results.stream().map(WorkingCopierResult::nonEntitiesToStore).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
            List entitiesToStore = results.stream().map(WorkingCopierResult::originalEntities).flatMap(Collection::stream).toList();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Collected {} non-entities to store.", (Object)nonEntitiesToStore.size());
            }
            this.storage.store(nonEntitiesToStore, this.domainClass, entitiesToStore);
        });
    }

    @Nonnull
    public <S extends T> S save(@Nonnull S entity) {
        return (S)this.storage.getReadWriteLock().write(() -> this.saveBulk(List.of(this.checkEntityForNull(entity))).get(0));
    }

    private <S> S checkEntityForNull(S entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity must not be null");
        }
        return entity;
    }

    @Nonnull
    public <S extends T> List<S> saveAll(@Nonnull Iterable<S> entities) {
        return this.storage.getReadWriteLock().write(() -> {
            ArrayList list = new ArrayList();
            this.checkEntityForNull(entities).forEach(list::add);
            return this.saveBulk(list);
        });
    }

    @Nonnull
    public Optional<T> findById(@Nonnull ID id) {
        return this.storage.getReadWriteLock().read(() -> this.storage.getEntityList(this.domainClass).parallelStream().filter(entity -> {
            try (FieldAccessModifier<Object> fam = FieldAccessModifier.prepareForField(this.getIdField(), entity);){
                if (!id.equals(fam.getValueOfField(entity))) return false;
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new FieldAccessReflectionException(String.format("Could not read field %s", this.getIdField().getName()), e);
            }
        }).findAny().map(foundEntity -> this.copier.copy(foundEntity)));
    }

    public boolean existsById(@Nonnull ID id) {
        return this.findById(id).isPresent();
    }

    @Nonnull
    public List<T> findAll() {
        return this.copier.copy(this.storage.getEntityList(this.domainClass)).stream().toList();
    }

    @Nonnull
    public List<T> findAllById(@Nonnull Iterable<ID> idsToFind) {
        return this.storage.getReadWriteLock().read(() -> this.copier.copy(this.storage.getEntityList(this.domainClass).parallelStream().filter(entity -> {
            try (FieldAccessModifier<Object> fam = FieldAccessModifier.prepareForField(this.getIdField(), entity);){
                Object idToFind;
                Object idOfEntity = fam.getValueOfField(entity);
                Iterator iterator = idsToFind.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!(idToFind = iterator.next()).equals(idOfEntity));
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new FieldAccessReflectionException(String.format("Could not read field %s", this.getIdField().getName()), e);
            }
        }).toList()));
    }

    public long count() {
        return this.storage.getEntityCount(this.domainClass);
    }

    public void deleteById(@Nonnull ID id) {
        this.storage.getReadWriteLock().write(() -> {
            Optional<Object> byId = this.findById(id);
            byId.ifPresent(this::delete);
        });
    }

    public void delete(@Nonnull T entity) {
        EclipseStoreTransaction transaction = this.transactionManager.getTransaction();
        transaction.addAction(() -> this.storage.getReadWriteLock().write(() -> {
            this.storage.delete(this.domainClass, this.copier.getOriginal(entity));
            this.copier.deregister(entity);
        }));
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        this.storage.getReadWriteLock().write(() -> {
            for (Object id : ids) {
                this.deleteById(id);
            }
        });
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.storage.getReadWriteLock().write(() -> {
            for (Object entity : entities) {
                this.delete(entity);
            }
        });
    }

    public void deleteAll() {
        EclipseStoreTransaction transaction = this.transactionManager.getTransaction();
        transaction.addAction(() -> this.storage.deleteAll(this.domainClass));
    }

    @Nonnull
    public List<T> findAll(@Nonnull Sort sort) {
        ListQueryExecutor<T> query = new ListQueryExecutor<T>(this.copier, Criteria.createNoCriteria());
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{sort}));
    }

    @Nonnull
    public Page<T> findAll(@Nonnull Pageable pageable) {
        PageableQueryExecutor<T> pageableQuery = new PageableQueryExecutor<T>(this.copier, Criteria.createNoCriteria(), null);
        return this.storage.getReadWriteLock().read(() -> pageableQuery.execute(this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{pageable}));
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        SingleOptionalQueryExecutor<T> query = new SingleOptionalQueryExecutor<T>(this.copier, new CriteriaByExample(example), null);
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), (Object[])null));
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        ListQueryExecutor<T> query = new ListQueryExecutor<T>(this.copier, new CriteriaByExample(example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), (Object[])null));
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        ListQueryExecutor<T> query = new ListQueryExecutor<T>(this.copier, new CriteriaByExample(example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{sort}));
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        PageableQueryExecutor<T> pageableQuery = new PageableQueryExecutor<T>(this.copier, new CriteriaByExample(example), null);
        return this.storage.getReadWriteLock().read(() -> pageableQuery.execute(this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{pageable}));
    }

    public <S extends T> long count(Example<S> example) {
        CountQueryExecutor query = new CountQueryExecutor(new CriteriaByExample(example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), (Object[])null));
    }

    public <S extends T> boolean exists(Example<S> example) {
        ExistsQueryExecutor query = new ExistsQueryExecutor(new CriteriaByExample(example));
        return this.storage.getReadWriteLock().read(() -> query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), (Object[])null));
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        EclipseStoreFetchableFluentQuery query = new EclipseStoreFetchableFluentQuery(this.copier, example, this.domainClass, this.storage, null);
        return (R)this.storage.getReadWriteLock().read(() -> queryFunction.apply(query));
    }
}

