/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import software.xdev.spring.data.eclipse.store.exceptions.NoPageableObjectFoundException;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.CountQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.PageableSortableCollectionQuerier;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class PageableQueryExecutor<T>
implements QueryExecutor<T> {
    private final PageableSortableCollectionQuerier<T> querier;
    private final CountQueryExecutor<T> countQueryExecutor;

    public PageableQueryExecutor(WorkingCopier<T> copier, Criteria<T> criteria, Sort sort) {
        this.querier = new PageableSortableCollectionQuerier<T>(copier, criteria, sort);
        this.countQueryExecutor = new CountQueryExecutor<T>(criteria);
    }

    public Page<T> execute(Class<T> clazz, @Nullable Collection<T> entities, Object[] values) {
        Objects.requireNonNull(clazz);
        if (entities == null || entities.isEmpty()) {
            return Page.empty();
        }
        if (values != null && values.length > 0) {
            Object object = values[values.length - 1];
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                Object total = this.countQueryExecutor.execute((Class)clazz, (Collection)entities, (Object[])null);
                return new PageImpl(this.querier.getEntities(entities, pageable, clazz), pageable, ((Long)total).longValue());
            }
            object = values[values.length - 1];
            if (object instanceof Sort) {
                Sort sort = (Sort)object;
                return new PageImpl(this.querier.getEntities(entities, clazz, sort));
            }
        }
        throw new NoPageableObjectFoundException("Could not execute query, because there is no Pageable or Sort object given.");
    }
}

