/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;

public class CountQueryExecutor<T>
implements QueryExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CountQueryExecutor.class);
    private final Criteria<T> criteria;

    public CountQueryExecutor(Criteria<T> criteria) {
        this.criteria = criteria;
    }

    @Override
    public Long execute(Class<T> clazz, @Nullable Collection<T> entities, Object[] values) {
        Objects.requireNonNull(entities);
        Stream<Object> entityStream = entities.stream().filter(this.criteria::evaluate);
        long result = entityStream.count();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found {} entries.", (Object)result);
        }
        return result;
    }
}

