/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.criteria;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import software.xdev.spring.data.eclipse.store.repository.access.AccessHelper;
import software.xdev.spring.data.eclipse.store.repository.query.ReflectedField;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;

public class CriteriaByExample<T, S extends T>
implements Criteria<T> {
    private final Predicate<T> predicate;

    public CriteriaByExample(Example<S> example) {
        this.predicate = example.getMatcher().isAllMatching() ? entity -> this.getDefinedOrDefaultSpecifiers(example).stream().allMatch(this.createPredicateForSpecifier(example, entity)) : entity -> this.getDefinedOrDefaultSpecifiers(example).stream().anyMatch(this.createPredicateForSpecifier(example, entity));
    }

    private Collection<ExampleMatcher.PropertySpecifier> getDefinedOrDefaultSpecifiers(Example<S> example) {
        Collection specifiers = example.getMatcher().getPropertySpecifiers().getSpecifiers();
        if (!specifiers.isEmpty()) {
            return specifiers;
        }
        ExampleMatcher matcher = ExampleMatcher.matching();
        Map<String, Field> allFields = AccessHelper.getInheritedPrivateFieldsByName(example.getProbeType());
        for (String fieldName : allFields.keySet()) {
            matcher = matcher.withMatcher(fieldName, ExampleMatcher.GenericPropertyMatchers.exact());
        }
        return matcher.getPropertySpecifiers().getSpecifiers();
    }

    @Override
    public boolean evaluate(T object) {
        return this.predicate.test(object);
    }

    private <T> Predicate<ExampleMatcher.PropertySpecifier> createPredicateForSpecifier(Example<S> example, T entity) {
        return specifier -> {
            ReflectedField reflectedField = ReflectedField.createReflectedField(example.getProbeType(), specifier.getPath());
            Object exampleValue = reflectedField.readValue(example.getProbe());
            Optional transformedExampledValue = (Optional)specifier.getPropertyValueTransformer().apply(Optional.ofNullable(exampleValue));
            if (transformedExampledValue.isEmpty()) {
                return true;
            }
            Object value = reflectedField.readValue(entity);
            Optional transformedValue = (Optional)specifier.getPropertyValueTransformer().apply(Optional.ofNullable(value));
            ExampleMatcher.StringMatcher setOrDefaultMatcher = specifier.getStringMatcher() == null ? example.getMatcher().getDefaultStringMatcher() : specifier.getStringMatcher();
            switch (setOrDefaultMatcher) {
                case DEFAULT: 
                case EXACT: {
                    if (transformedExampledValue.get() instanceof String) {
                        return this.valueToString(transformedValue, (ExampleMatcher.PropertySpecifier)specifier).equals(this.valueToString(transformedExampledValue, (ExampleMatcher.PropertySpecifier)specifier));
                    }
                    return transformedExampledValue.equals(transformedValue);
                }
                case STARTING: {
                    Optional<String> valueAsString = this.valueToString(transformedValue, (ExampleMatcher.PropertySpecifier)specifier);
                    if (valueAsString.isEmpty()) {
                        return false;
                    }
                    return valueAsString.get().startsWith(this.valueToString(transformedExampledValue, (ExampleMatcher.PropertySpecifier)specifier).get());
                }
                case ENDING: {
                    Optional<String> valueAsString = this.valueToString(transformedValue, (ExampleMatcher.PropertySpecifier)specifier);
                    if (valueAsString.isEmpty()) {
                        return false;
                    }
                    return valueAsString.get().endsWith(this.valueToString(transformedExampledValue, (ExampleMatcher.PropertySpecifier)specifier).get());
                }
                case CONTAINING: {
                    Optional<String> valueAsString = this.valueToString(transformedValue, (ExampleMatcher.PropertySpecifier)specifier);
                    if (valueAsString.isEmpty()) {
                        return false;
                    }
                    return valueAsString.get().contains(this.valueToString(transformedExampledValue, (ExampleMatcher.PropertySpecifier)specifier).get());
                }
                case REGEX: {
                    Optional<String> valueAsString = this.valueToString(transformedValue, (ExampleMatcher.PropertySpecifier)specifier);
                    if (valueAsString.isEmpty()) {
                        return false;
                    }
                    return Pattern.compile(this.valueToString(transformedExampledValue, (ExampleMatcher.PropertySpecifier)specifier).get()).matcher(valueAsString.get()).find();
                }
            }
            return false;
        };
    }

    private Optional<String> valueToString(Optional<Object> value, ExampleMatcher.PropertySpecifier specifier) {
        if (value.isEmpty()) {
            return Optional.empty();
        }
        if (specifier != null && Boolean.TRUE.equals(specifier.getIgnoreCase())) {
            return Optional.of(value.get().toString().toLowerCase(Locale.ROOT));
        }
        return Optional.of(value.get().toString());
    }
}

