/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ObjectUtils;
import software.xdev.spring.data.eclipse.store.repository.query.ReflectedField;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.AbstractCriteriaNode;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.CriteriaSingleNode;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutorCreator;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

@Nonnull
public class EclipseStoreQueryCreator<T>
extends AbstractQueryCreator<QueryExecutor<T>, AbstractCriteriaNode<T>> {
    private final TypeInformation<?> typeInformation;
    private final Class<T> domainClass;
    private final WorkingCopier<T> copier;

    public EclipseStoreQueryCreator(Class<T> domainClass, TypeInformation<?> typeInformation, WorkingCopier<T> copier, PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.domainClass = Objects.requireNonNull(domainClass);
        this.typeInformation = Objects.requireNonNull(typeInformation);
        this.copier = Objects.requireNonNull(copier);
    }

    @Nonnull
    protected AbstractCriteriaNode<T> create(@Nonnull Part part, @Nonnull Iterator<Object> iterator) {
        Objects.requireNonNull(part);
        Objects.requireNonNull(iterator);
        return this.from(part, new CriteriaSingleNode<T>(this.getDeclaredField(part)), iterator);
    }

    @Nonnull
    protected AbstractCriteriaNode<T> and(@Nonnull Part part, @Nullable AbstractCriteriaNode<T> base, @Nonnull Iterator<Object> iterator) {
        Objects.requireNonNull(part);
        Objects.requireNonNull(iterator);
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        return this.from(part, base.and(this.getDeclaredField(part)), iterator);
    }

    @Nonnull
    protected AbstractCriteriaNode<T> or(@Nonnull AbstractCriteriaNode<T> base, @Nonnull AbstractCriteriaNode<T> criteria) {
        Objects.requireNonNull(base);
        Objects.requireNonNull(criteria);
        return base.orOperator(criteria);
    }

    @Nonnull
    protected QueryExecutor<T> complete(AbstractCriteriaNode<T> criteria, @Nonnull Sort sort) {
        Objects.requireNonNull(sort);
        if (criteria == null) {
            return QueryExecutorCreator.createQuery(this.typeInformation, this.copier, Criteria.createNoCriteria(), sort);
        }
        return QueryExecutorCreator.createQuery(this.typeInformation, this.copier, criteria, sort);
    }

    private AbstractCriteriaNode<T> from(Part part, AbstractCriteriaNode<T> criteria, @Nullable Iterator<Object> parameters) {
        Objects.requireNonNull(criteria);
        Part.Type type = Objects.requireNonNull(part).getType();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return criteria.gt(Objects.requireNonNull(parameters).next());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(Objects.requireNonNull(parameters).next());
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lt(Objects.requireNonNull(parameters).next());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(Objects.requireNonNull(parameters).next());
            }
            case BETWEEN: {
                return criteria.between(Objects.requireNonNull(parameters).next(), Objects.requireNonNull(parameters).next());
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case NOT_IN: {
                return criteria.nin(this.asStreamable(Objects.requireNonNull(parameters).next()));
            }
            case IN: {
                return criteria.in(this.asStreamable(Objects.requireNonNull(parameters).next()));
            }
            case LIKE: {
                return criteria.like((String)Objects.requireNonNull(parameters).next());
            }
            case STARTING_WITH: {
                return criteria.startWith((String)Objects.requireNonNull(parameters).next());
            }
            case ENDING_WITH: {
                return criteria.endWith((String)Objects.requireNonNull(parameters).next());
            }
            case CONTAINING: {
                return criteria.containing((String)Objects.requireNonNull(parameters).next());
            }
            case NOT_LIKE: {
                return criteria.notLike((String)Objects.requireNonNull(parameters).next());
            }
            case NOT_CONTAINING: {
                return criteria.notContaining((String)Objects.requireNonNull(parameters).next());
            }
            case EXISTS: {
                return criteria.exists((Boolean)Objects.requireNonNull(parameters).next());
            }
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case SIMPLE_PROPERTY: {
                if (!this.isSimpleComparisonPossible(part)) break;
                return criteria.is(Objects.requireNonNull(parameters).next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                if (!this.isSimpleComparisonPossible(part)) break;
                return criteria.ne(Objects.requireNonNull(parameters).next());
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword");
            }
        }
        throw new IllegalArgumentException("Unsupported keyword");
    }

    private Streamable<?> asStreamable(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return Streamable.of((Iterable)collection);
        }
        if (ObjectUtils.isArray((Object)value)) {
            return Streamable.of((Object[])((Object[])value));
        }
        return Streamable.of((Object[])new Object[]{value});
    }

    private boolean isSimpleComparisonPossible(Part part) {
        return switch (part.shouldIgnoreCase()) {
            default -> throw new IncompatibleClassChangeError();
            case Part.IgnoreCaseType.NEVER -> true;
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> {
                if (part.getProperty().getType() != String.class) {
                    yield true;
                }
                yield false;
            }
            case Part.IgnoreCaseType.ALWAYS -> false;
        };
    }

    private ReflectedField<T, ?> getDeclaredField(Part part) {
        String fieldName = part.getProperty().getSegment();
        return ReflectedField.createReflectedField(this.domainClass, fieldName);
    }
}

