/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.lazy;

import java.lang.reflect.Field;
import java.util.Objects;
import org.eclipse.serializer.reference.Lazy;
import org.eclipse.serializer.reference.ObjectSwizzling;
import org.eclipse.serializer.reference.Swizzling;
import software.xdev.spring.data.eclipse.store.exceptions.LazyNotUnlinkableException;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public interface SpringDataEclipseStoreLazy<T>
extends Lazy<T> {
    public static <T> Default<T> build(T objectToWrapInLazy) {
        return new Default<T>(objectToWrapInLazy);
    }

    public SpringDataEclipseStoreLazy<T> copyWithReference();

    public void unlink();

    public long objectId();

    public boolean isOriginalObject();

    public static class Default<T>
    implements SpringDataEclipseStoreLazy<T> {
        private T objectToBeWrapped;
        private Lazy<T> wrappedLazy;
        private long objectId = Swizzling.notFoundId();
        private transient ObjectSwizzling loader;
        private transient WorkingCopier<T> copier;
        private transient boolean isStored;

        private Default(Lazy<T> lazySubject) {
            this.setWrappedLazy(lazySubject);
        }

        private Default(T objectToBeWrapped) {
            this.objectToBeWrapped = objectToBeWrapped;
        }

        private Default(long objectId, ObjectSwizzling loader, WorkingCopier<T> copier) {
            this.objectId = objectId;
            this.loader = loader;
            this.copier = copier;
            this.setStored();
        }

        private Lazy<T> ensureLazy() {
            if (this.wrappedLazy == null || !this.wrappedLazy.isLoaded()) {
                this.wrappedLazy = this.createNewDefaultLazyWithClearableReference();
            }
            return this.wrappedLazy;
        }

        private Lazy<T> createNewDefaultLazyWithClearableReference() {
            Objects.requireNonNull(this.loader);
            Objects.requireNonNull(this.copier);
            Object originalInstance = this.loader.getObject(this.objectId);
            Object copiedInstance = this.copier.onlyCreateCopy(originalInstance, false);
            return Lazy.New((Object)copiedInstance, (long)Swizzling.nullId(), (ObjectSwizzling)this.loader);
        }

        public T get() {
            if (this.objectToBeWrapped != null) {
                return this.objectToBeWrapped;
            }
            return (T)this.ensureLazy().get();
        }

        public T peek() {
            return (T)this.ensureLazy().peek();
        }

        public T clear() {
            if (!this.isStored()) {
                throw new IllegalStateException("Cannot clear an unstored lazy reference.");
            }
            return this.forceClear();
        }

        public T forceClear() {
            this.objectId = this.objectId();
            this.wrappedLazy = null;
            return null;
        }

        public boolean isStored() {
            return this.isStored;
        }

        void setStored() {
            this.isStored = true;
        }

        public boolean isLoaded() {
            if (this.objectToBeWrapped != null) {
                return true;
            }
            if (this.wrappedLazy == null) {
                return false;
            }
            return this.wrappedLazy.isLoaded();
        }

        public long lastTouched() {
            return this.ensureLazy().lastTouched();
        }

        public boolean clear(Lazy.ClearingEvaluator clearingEvaluator) {
            if (this.wrappedLazy != null) {
                return this.wrappedLazy.clear(clearingEvaluator);
            }
            return true;
        }

        @Override
        public long objectId() {
            Lazy<T> lazy;
            if (this.wrappedLazy != null && (lazy = this.wrappedLazy) instanceof Lazy.Default) {
                Lazy.Default wrappedTypedLazy = (Lazy.Default)lazy;
                return wrappedTypedLazy.objectId();
            }
            return this.objectId;
        }

        void setWrappedLazy(Lazy<T> wrappedLazy) {
            this.wrappedLazy = wrappedLazy;
            this.setStored();
        }

        public T getObjectToBeWrapped() {
            return this.objectToBeWrapped;
        }

        @Override
        public SpringDataEclipseStoreLazy<T> copyWithReference() {
            Default<T> newLazy = new Default<T>(this.objectId(), this.loader, this.copier);
            newLazy.wrappedLazy = this.wrappedLazy;
            return newLazy;
        }

        @Override
        public void unlink() {
            block8: {
                try {
                    if (this.wrappedLazy == null) break block8;
                    Lazy.Default wrappedDefaultLazy = (Lazy.Default)this.wrappedLazy;
                    wrappedDefaultLazy.$unlink();
                    Field objectIdField = Lazy.Default.class.getDeclaredField("objectId");
                    try (FieldAccessModifier<Lazy.Default> fam = FieldAccessModifier.prepareForField(objectIdField, wrappedDefaultLazy);){
                        fam.writeValueOfField(wrappedDefaultLazy, Swizzling.nullId(), true);
                    }
                }
                catch (Exception e) {
                    throw new LazyNotUnlinkableException("Could not unlink lazy " + this.wrappedLazy, e);
                }
            }
        }

        @Override
        public boolean isOriginalObject() {
            return this.objectToBeWrapped != null;
        }
    }

    public static interface Internals {
        public static <T> Default<T> buildWithLazy(Lazy<T> lazySubject) {
            return new Default<Lazy<T>>(lazySubject);
        }
    }
}

