/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.core.IdentitySet;

public class EntitySetCollector {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySetCollector.class);
    private final Map<Class<?>, List<IdentitySet<? super Object>>> childClassToParentSets = new HashMap();

    public EntitySetCollector(Function<Class<?>, IdentitySet<?>> entityLists, Set<Class<?>> entityClasses) {
        this.buildParentClassList(entityLists, entityClasses);
    }

    private void buildParentClassList(Function<Class<?>, IdentitySet<?>> entityLists, Set<Class<?>> entityClasses) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing parent class list...");
        }
        for (Class<?> possibleParentEntry : entityClasses) {
            for (Class<?> possibleChildEntry : entityClasses) {
                this.childClassToParentSets.putIfAbsent(possibleChildEntry, new ArrayList());
                if (!possibleParentEntry.isAssignableFrom(possibleChildEntry)) continue;
                this.childClassToParentSets.get(possibleChildEntry).add(entityLists.apply(possibleParentEntry));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done initializing parent class list.");
        }
    }

    public <T> List<IdentitySet<Object>> getRelatedIdentitySets(Class<T> clazz) {
        return this.childClassToParentSets.get(clazz);
    }
}

