/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.EntitySorter;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class PageableSortableCollectionQuerier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PageableSortableCollectionQuerier.class);
    private final Criteria<T> criteria;
    private final WorkingCopier<T> copier;
    private final Optional<Sort> staticSort;

    public PageableSortableCollectionQuerier(WorkingCopier<T> copier, Criteria<T> criteria) {
        this(copier, criteria, null);
    }

    public PageableSortableCollectionQuerier(WorkingCopier<T> copier, Criteria<T> criteria, Sort sort) {
        this.criteria = Objects.requireNonNull(criteria);
        this.copier = Objects.requireNonNull(copier);
        this.staticSort = Optional.ofNullable(sort);
    }

    protected List<T> getEntities(@Nonnull Collection<T> entities, @Nullable Pageable pageable, @Nullable Class<T> clazz, @Nullable Sort sort) {
        Objects.requireNonNull(entities);
        Stream<Object> entityStream = entities.stream().filter(this.criteria::evaluate);
        Sort sortToUse = this.staticSort.orElse(sort);
        if (sortToUse != null) {
            entityStream = EntitySorter.sortEntitiesStream(clazz, sortToUse, entityStream);
        }
        entityStream = this.pageEntityStream(pageable, entityStream);
        List<Object> result = this.copyEntities(entityStream);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found {} entries.", (Object)result.size());
        }
        return result;
    }

    private List<T> copyEntities(Stream<T> filteredEntityStream) {
        return filteredEntityStream.map(this.copier::copy).toList();
    }

    private Stream<T> pageEntityStream(Pageable pageable, Stream<T> entityStream) {
        if (pageable != null && pageable.isPaged()) {
            long skipCount = pageable.getOffset();
            return entityStream.skip(skipCount).limit(pageable.getPageSize());
        }
        return entityStream;
    }

    protected List<T> getEntities(Collection<T> entities, Pageable pageable, Class<T> clazz) {
        return this.getEntities(entities, pageable, clazz, pageable.getSort());
    }

    protected List<T> getEntities(Collection<T> entities, Class<T> clazz, Sort sort) {
        return this.getEntities(entities, null, clazz, sort);
    }

    protected List<T> getEntities(Collection<T> entities, Class<T> clazz) {
        return this.getEntities(entities, null, clazz, null);
    }
}

