/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.access.modifier;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;

public class FieldAccessibleMaker<E>
implements FieldAccessModifier<E> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldAccessibleMaker.class);
    private final Field field;
    private final boolean isFinal;

    FieldAccessibleMaker(Field field, E sourceObject) {
        this.field = field;
        boolean wasAccessible = field.canAccess(Objects.requireNonNull(sourceObject));
        int fieldModifiers = field.getModifiers();
        this.isFinal = Modifier.isFinal(fieldModifiers);
        if (!wasAccessible) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Make field {}#{} accessible.", (Object)this.field.getDeclaringClass().getSimpleName(), (Object)this.field.getName());
            }
            this.field.trySetAccessible();
        }
    }

    @Override
    public Object getValueOfField(E objectOfFieldToRead) throws IllegalAccessException {
        return this.field.get(objectOfFieldToRead);
    }

    @Override
    public void writeValueOfField(E objectOfFieldToWriteTo, Object valueToWrite, boolean throwExceptionIfFinal) throws IllegalAccessException {
        if (throwExceptionIfFinal && this.isFinal) {
            throw new IllegalAccessException(String.format("Field %s:%s is final and cannot be modified. Make the field not final.", objectOfFieldToWriteTo.toString(), this.field.getName()));
        }
        this.field.set(objectOfFieldToWriteTo, valueToWrite);
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public void close() {
    }
}

