/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.access;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.util.StringUtil;

public final class AccessHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AccessHelper.class);

    private AccessHelper() {
    }

    public static Map<String, Field> getInheritedPrivateFieldsByName(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        HashMap<String, Field> result = new HashMap<String, Field>();
        for (Class<?> i = clazz; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.put(field.getName(), field);
            }
        }
        return result;
    }

    public static Field getInheritedPrivateField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Objects.requireNonNull(clazz);
        StringUtil.requireNonNullAndNonBlank(fieldName);
        Map<String, Field> inheritedPrivateFieldsByName = AccessHelper.getInheritedPrivateFieldsByName(clazz);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} fields in class {}.", (Object)inheritedPrivateFieldsByName.size(), (Object)clazz.getSimpleName());
        }
        if (!inheritedPrivateFieldsByName.containsKey(fieldName)) {
            throw new NoSuchFieldException(String.format("Could not find field %s in class %s", fieldName, clazz.getSimpleName()));
        }
        return inheritedPrivateFieldsByName.get(fieldName);
    }

    public static <T> Object readFieldVariable(Field field, T sourceObject) {
        Object object;
        block8: {
            FieldAccessModifier<T> fieldAccessModifier = FieldAccessModifier.prepareForField(Objects.requireNonNull(field), Objects.requireNonNull(sourceObject));
            try {
                object = fieldAccessModifier.getValueOfField(sourceObject);
                if (fieldAccessModifier == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fieldAccessModifier != null) {
                        try {
                            fieldAccessModifier.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FieldAccessReflectionException(field, e);
                }
            }
            fieldAccessModifier.close();
        }
        return object;
    }
}

