/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.core.IdentitySet;

public class EntitySetCollector {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySetCollector.class);
    private final Map<Class<?>, List<IdentitySet<? super Object>>> childClassToParentSets = new HashMap();

    public EntitySetCollector(Map<String, IdentitySet<Object>> entityLists, Map<Class<?>, String> entityClassToRepositoryName) {
        this.buildParentClassList(entityLists, entityClassToRepositoryName);
    }

    private void buildParentClassList(Map<String, IdentitySet<Object>> entityLists, Map<Class<?>, String> entityClassToRepositoryName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing parent class list...");
        }
        for (Map.Entry<Class<?>, String> possibleParentEntry : entityClassToRepositoryName.entrySet()) {
            for (Map.Entry<Class<?>, String> possibleChildEntry : entityClassToRepositoryName.entrySet()) {
                this.childClassToParentSets.putIfAbsent(possibleChildEntry.getKey(), new ArrayList());
                if (!possibleParentEntry.getKey().isAssignableFrom(possibleChildEntry.getKey())) continue;
                this.childClassToParentSets.get(possibleChildEntry.getKey()).add(entityLists.get(entityClassToRepositoryName.get(possibleParentEntry.getKey())));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done initializing parent class list.");
        }
    }

    public <T> List<IdentitySet<Object>> getRelatedIdentitySets(Class<T> clazz) {
        return this.childClassToParentSets.get(clazz);
    }
}

