/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.id;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.exceptions.IdFieldFinalException;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdSetter;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.IdFinder;

public class SimpleIdSetter<T, ID>
implements IdSetter<T> {
    private final IdFinder<ID> idFinder;
    private final Field idField;
    private final Consumer<ID> lastIdPersister;

    public SimpleIdSetter(Field idField, IdFinder<ID> idFinder, Consumer<Object> lastIdPersister) {
        this.idField = idField;
        this.idFinder = idFinder;
        this.lastIdPersister = lastIdPersister::accept;
        this.checkIfIdFieldIsFinal();
    }

    private void checkIfIdFieldIsFinal() {
        int fieldModifiers = this.idField.getModifiers();
        if (Modifier.isFinal(fieldModifiers)) {
            throw new IdFieldFinalException(String.format("Field %s is final and cannot be modified. ID fields must not be final.", this.idField.getName()));
        }
    }

    @Override
    public void ensureId(T objectToSetIdIn) {
        try (FieldAccessModifier<T> fam = FieldAccessModifier.prepareForField(this.idField, objectToSetIdIn);){
            Object existingId = fam.getValueOfField(objectToSetIdIn);
            if (existingId == null) {
                ID newId = this.idFinder.findId();
                fam.writeValueOfField(objectToSetIdIn, newId, true);
                this.lastIdPersister.accept(newId);
            }
        }
        catch (Exception e) {
            throw new FieldAccessReflectionException(this.idField, e);
        }
    }
}

