/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository;

import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.exceptions.DifferentClassesException;

public class WorkingCopyRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WorkingCopyRegistry.class);
    private Map<Object, Object> currentWorkingCopies = new IdentityHashMap<Object, Object>();

    public synchronized <T> boolean invertRegister(T workingCopy, T objectToStore) {
        return this.registerInternal(objectToStore, workingCopy);
    }

    public synchronized <T> boolean register(T workingCopyToRegister, T orginalObject) {
        return this.registerInternal(workingCopyToRegister, orginalObject);
    }

    private synchronized <T> boolean registerInternal(T keyObject, T valueObject) {
        if (keyObject.getClass() != valueObject.getClass()) {
            throw new DifferentClassesException("There is a critical error creating a working copy.");
        }
        if (this.currentWorkingCopies.containsKey(keyObject)) {
            return false;
        }
        this.currentWorkingCopies.put(keyObject, valueObject);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Registered a object of class {}. Registered objects: {}", valueObject.getClass(), (Object)this.currentWorkingCopies.size());
        }
        return true;
    }

    public synchronized <T> T getOriginalObjectFromWorkingCopy(T working) {
        return (T)this.currentWorkingCopies.get(working);
    }

    public synchronized void deregister(Object workingCopyToDeregister) {
        this.currentWorkingCopies.remove(workingCopyToDeregister);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Deregistered a object of class {}. Registered objects: {}", workingCopyToDeregister.getClass(), (Object)this.currentWorkingCopies.size());
        }
    }

    public synchronized void reset() {
        this.currentWorkingCopies = new IdentityHashMap<Object, Object>();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cleared WorkingCopyRegistry");
        }
    }
}

