/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.importer;

import jakarta.persistence.EntityManagerFactory;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import software.xdev.spring.data.eclipse.store.importer.EclipseStoreDataImporter;
import software.xdev.spring.data.eclipse.store.repository.config.EclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.support.SimpleEclipseStoreRepository;

@Component
@Lazy
public class EclipseStoreDataImporterComponent {
    private final EclipseStoreDataImporter importer;
    private final ApplicationContext applicationContext;

    public EclipseStoreDataImporterComponent(EclipseStoreClientConfiguration configuration, ApplicationContext applicationContext) {
        this.importer = new EclipseStoreDataImporter(configuration);
        this.applicationContext = applicationContext;
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData() {
        Map beansOfEms = this.applicationContext.getBeansOfType(EntityManagerFactory.class);
        return this.importer.importData(beansOfEms.values());
    }
}

