/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.working;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.serializer.persistence.types.Unpersistable;
import software.xdev.spring.data.eclipse.store.repository.PersistableChecker;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.ChangedObjectCollector;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopierResult;

public class HashSetChangedObjectCollector<T>
implements ChangedObjectCollector,
Unpersistable {
    private final List<Object> nonEntityObjects = new ArrayList<Object>();
    private final List<T> entityObjects = new ArrayList<T>();
    private final Class<T> entityClass;
    private final PersistableChecker persistableChecker;

    public HashSetChangedObjectCollector(Class<T> entityClass, PersistableChecker persistableChecker) {
        this.entityClass = entityClass;
        this.persistableChecker = persistableChecker;
    }

    @Override
    public void collectChangedObject(Object changedObject) {
        if (!this.persistableChecker.isPersistable(changedObject.getClass())) {
            return;
        }
        if (this.entityClass.isInstance(changedObject)) {
            this.entityObjects.add(changedObject);
        } else {
            this.nonEntityObjects.add(changedObject);
        }
    }

    public WorkingCopierResult<T> toResult() {
        return new WorkingCopierResult(this.entityObjects.stream().collect(Collectors.toUnmodifiableSet()), this.nonEntityObjects.stream().collect(Collectors.toUnmodifiableSet()));
    }
}

