/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.registering;

import java.util.HashMap;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryStorer;
import org.eclipse.serializer.persistence.types.PersistenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.exceptions.DataTypeNotSupportedException;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.support.copier.DataTypeUtil;
import software.xdev.spring.data.eclipse.store.repository.support.copier.registering.RegisteringWorkingCopyAndOriginal;

public class EclipseSerializerRegisteringCopier
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseSerializerRegisteringCopier.class);
    private PersistenceManager<Binary> persistenceManager;
    private final SupportedChecker supportedChecker;
    private final RegisteringWorkingCopyAndOriginal register;

    public EclipseSerializerRegisteringCopier(SupportedChecker supportedChecker, RegisteringWorkingCopyAndOriginal register, PersistenceManager<Binary> persistenceManager) {
        this.supportedChecker = supportedChecker;
        this.register = register;
        this.persistenceManager = persistenceManager;
    }

    @Override
    public synchronized void close() {
        if (this.persistenceManager != null) {
            this.persistenceManager.objectRegistry().clearAll();
            this.persistenceManager.close();
            this.persistenceManager = null;
        }
    }

    public synchronized <T> T copy(T source) {
        this.persistenceManager.objectRegistry().truncateAll();
        BinaryStorer.Default storer = (BinaryStorer.Default)this.persistenceManager.createStorer();
        PersistenceLoader loader = this.persistenceManager.createLoader();
        storer.store(source);
        HashMap originalObjects = new HashMap();
        storer.iterateMergeableEntries(originalObjects::put);
        storer.commit();
        Object returnValue = loader.get();
        Summarizer summarizer = new Summarizer();
        loader.iterateEntries((id, copiedObject) -> {
            if (copiedObject != null && !this.supportedChecker.isSupported(copiedObject.getClass())) {
                throw new DataTypeNotSupportedException(copiedObject.getClass());
            }
            summarizer.incrementCopiedObjectsCount();
            if (DataTypeUtil.isPrimitiveType(copiedObject.getClass())) {
                return;
            }
            Object originalObject = originalObjects.get(id);
            if (originalObject != null) {
                summarizer.incrementRegisteredObjectsCount();
                this.register.register(copiedObject, originalObject);
            }
        });
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copied {} and registered {} objects.", (Object)summarizer.copiedObjectsCount, (Object)summarizer.registeredObjectsCount);
        }
        return (T)returnValue;
    }

    private static class Summarizer {
        private long copiedObjectsCount = 0L;
        private long registeredObjectsCount = 0L;

        public void incrementCopiedObjectsCount() {
            ++this.copiedObjectsCount;
        }

        public void incrementRegisteredObjectsCount() {
            ++this.registeredObjectsCount;
        }
    }
}

