/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.id;

import jakarta.persistence.GeneratedValue;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.xdev.spring.data.eclipse.store.repository.support.IdFieldFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.NotSettingIdSetter;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.SimpleIdSetter;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.IdFinder;

public interface IdSetter<T> {
    public static <T> IdSetter<T> createIdSetter(Class<T> classWithId, Consumer<Object> lastIdPersister, Supplier<Object> lastIdGetter) {
        Objects.requireNonNull(classWithId);
        Objects.requireNonNull(lastIdPersister);
        Objects.requireNonNull(lastIdGetter);
        Optional<Field> idField = IdFieldFinder.findIdField(classWithId);
        if (idField.isEmpty()) {
            return new NotSettingIdSetter();
        }
        GeneratedValue generatedValueAnnotation = idField.get().getAnnotation(GeneratedValue.class);
        if (generatedValueAnnotation == null) {
            return new NotSettingIdSetter();
        }
        return new SimpleIdSetter(idField.get(), IdFinder.createIdFinder(idField.get(), generatedValueAnnotation, lastIdGetter), lastIdPersister);
    }

    public void ensureId(T var1);
}

