/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.support.EclipseStoreQueryLookupStrategy;
import software.xdev.spring.data.eclipse.store.repository.support.SimpleEclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.RecursiveWorkingCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public class EclipseStoreRepositoryFactory
extends RepositoryFactorySupport {
    private final EclipseStoreStorage storage;

    public EclipseStoreRepositoryFactory(EclipseStoreStorage storage) {
        this.storage = storage;
    }

    @Nonnull
    public <T, ID> EntityInformation<T, ID> getEntityInformation(@Nonnull Class<T> domainClass) {
        return new PersistentEntityInformation((PersistentEntity)new BasicPersistentEntity(TypeInformation.of(domainClass)));
    }

    @Nonnull
    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, @Nonnull QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new EclipseStoreQueryLookupStrategy(this.storage, this::createWorkingCopier));
    }

    @Nonnull
    protected Object getTargetRepository(@Nonnull RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.storage, this.createWorkingCopier(metadata.getDomainType(), this.storage), metadata.getDomainType()});
    }

    private <T> WorkingCopier<T> createWorkingCopier(Class<T> domainType, EclipseStoreStorage storage) {
        return new RecursiveWorkingCopier<T>(domainType, storage.getRegistry(), storage, storage, new SupportedChecker.Implementation(), storage);
    }

    @Nonnull
    protected Class<?> getRepositoryBaseClass(@Nonnull RepositoryMetadata metadata) {
        return SimpleEclipseStoreRepository.class;
    }

    @Nonnull
    protected RepositoryInformation getRepositoryInformation(@Nonnull RepositoryMetadata metadata, @Nonnull RepositoryComposition.RepositoryFragments fragments) {
        return super.getRepositoryInformation(metadata, fragments);
    }

    @Nonnull
    public <T> T getRepository(@Nonnull Class<T> repositoryInterface, @Nonnull RepositoryComposition.RepositoryFragments fragments) {
        return (T)super.getRepository(repositoryInterface, fragments);
    }
}

