/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.Query;
import software.xdev.spring.data.eclipse.store.repository.query.FindAllEclipseStoreQueryProvider;
import software.xdev.spring.data.eclipse.store.repository.query.StringBasedEclipseStoreQueryProvider;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopierCreator;

public class EclipseStoreQueryLookupStrategy
implements QueryLookupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreQueryLookupStrategy.class);
    private final EclipseStoreStorage storage;
    private final WorkingCopierCreator workingCopierCreator;

    public EclipseStoreQueryLookupStrategy(EclipseStoreStorage storage, WorkingCopierCreator workingCopierCreator) {
        this.storage = storage;
        this.workingCopierCreator = workingCopierCreator;
    }

    @Nonnull
    public RepositoryQuery resolveQuery(@Nonnull Method method, @Nonnull RepositoryMetadata metadata, @Nonnull ProjectionFactory factory, @Nonnull NamedQueries namedQueries) {
        QueryMethod queryMethod = new QueryMethod(method, metadata, factory);
        if (method.getAnnotation(Query.class) != null) {
            LOG.warn("Annotation @Query is used in Repository {}. This is useless for now and should be deleted.", (Object)metadata.getRepositoryInterface().getSimpleName());
            if (method.getName().equalsIgnoreCase("findall")) {
                return this.createFindAllEclipseStoreQueryProvider(metadata.getDomainType(), queryMethod, method);
            }
        }
        return this.createStringBasedEclipseStoreQueryProvider(metadata.getDomainType(), queryMethod, method);
    }

    private <T> RepositoryQuery createFindAllEclipseStoreQueryProvider(Class<T> domainType, QueryMethod queryMethod, Method method) {
        return new FindAllEclipseStoreQueryProvider<T>(queryMethod, method, domainType, this.storage, this.workingCopierCreator.createWorkingCopier(domainType, this.storage));
    }

    private <T> RepositoryQuery createStringBasedEclipseStoreQueryProvider(Class<T> domainType, QueryMethod queryMethod, Method method) {
        return new StringBasedEclipseStoreQueryProvider<T>(queryMethod, method, domainType, this.storage, this.workingCopierCreator.createWorkingCopier(domainType, this.storage));
    }
}

