/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.config;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.util.ClassUtils;
import software.xdev.spring.data.eclipse.store.repository.config.DefaultEclipseStoreClientConfiguration;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreCustomRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListPagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStorePagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.support.EclipseStoreRepositoryFactoryBean;

public class EclipseStoreRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    @Nonnull
    public String getModuleName() {
        return "EclipseStoreDatastore";
    }

    @Nonnull
    public String getModulePrefix() {
        return this.getModuleIdentifier();
    }

    @Nonnull
    public String getRepositoryFactoryBeanClassName() {
        return EclipseStoreRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        Class configurationClass = attributes.getClass("clientConfigurationClass");
        String configurationString = attributes.getString("clientConfiguration");
        if (!configurationClass.equals(DefaultEclipseStoreClientConfiguration.class)) {
            configurationString = ClassUtils.getShortNameAsProperty((Class)configurationClass);
        }
        builder.addPropertyReference("configuration", configurationString);
    }

    @Nonnull
    public String getModuleIdentifier() {
        return "EclipseStore";
    }

    @Nonnull
    public Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptyList();
    }

    @Nonnull
    protected Collection<Class<?>> getIdentifyingTypes() {
        return List.of(EclipseStoreRepository.class, EclipseStoreCustomRepository.class, EclipseStorePagingAndSortingRepositoryRepository.class, EclipseStoreListPagingAndSortingRepositoryRepository.class, EclipseStoreCrudRepository.class, EclipseStoreListCrudRepository.class);
    }
}

