/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.reposyncer;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.serializer.util.traversing.ObjectGraphTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.core.IdentitySet;
import software.xdev.spring.data.eclipse.store.repository.Root;
import software.xdev.spring.data.eclipse.store.repository.support.reposyncer.RepositorySynchronizer;

public class SimpleRepositorySynchronizer
implements RepositorySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRepositorySynchronizer.class);
    private final Map<Class<?>, String> entityWithRepositoryNamesAndClasses;
    private final Root root;
    private final HashSet<IdentitySet<Object>> listsToStore;
    private final ObjectGraphTraverser buildObjectGraphTraverser;

    public SimpleRepositorySynchronizer(Map<Class<?>, String> entityWithRepositoryNamesAndClasses, Root root) {
        this.entityWithRepositoryNamesAndClasses = entityWithRepositoryNamesAndClasses;
        this.root = root;
        this.listsToStore = new HashSet();
        this.buildObjectGraphTraverser = ObjectGraphTraverser.Builder().modeFull().fieldPredicate(field -> !Modifier.isTransient(field.getModifiers())).acceptorLogic(objectInGraph -> {
            IdentitySet<Object> entityListForCurrentObject;
            if (objectInGraph == null) {
                return;
            }
            Class<?> objectInGraphClass = objectInGraph.getClass();
            String objectInGraphClassname = this.entityWithRepositoryNamesAndClasses.get(objectInGraphClass);
            if (objectInGraphClassname != null && !(entityListForCurrentObject = this.root.getEntityLists().get(objectInGraphClassname)).contains(objectInGraph)) {
                entityListForCurrentObject.add(objectInGraph);
                this.listsToStore.add(entityListForCurrentObject);
            }
        }).buildObjectGraphTraverser();
    }

    @Override
    public Collection<IdentitySet<Object>> syncAndReturnChangedObjectLists(Object objectToStore) {
        this.listsToStore.clear();
        this.buildObjectGraphTraverser.traverse(objectToStore);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Amount of changed entities: {}", (Object)this.listsToStore.size());
        }
        HashSet<IdentitySet<Object>> setOfChangedObjects = new HashSet<IdentitySet<Object>>(this.listsToStore);
        this.listsToStore.clear();
        return setOfChangedObjects;
    }
}

