/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.object;

import java.util.HashMap;
import org.eclipse.serializer.Serializer;
import org.eclipse.serializer.SerializerFoundation;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XReference;
import org.eclipse.serializer.persistence.binary.jdk17.java.util.BinaryHandlerImmutableCollectionsList12;
import org.eclipse.serializer.persistence.binary.jdk17.java.util.BinaryHandlerImmutableCollectionsSet12;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryStorer;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTransfer;
import org.eclipse.serializer.persistence.types.PersistenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceManager;
import org.eclipse.serializer.persistence.types.PersistenceSource;
import org.eclipse.serializer.persistence.types.PersistenceTarget;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.reference.Reference;
import org.eclipse.serializer.util.X;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.exceptions.DataTypeNotSupportedException;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.WorkingCopyRegistry;
import software.xdev.spring.data.eclipse.store.repository.support.copier.DataTypeUtil;
import software.xdev.spring.data.eclipse.store.repository.support.copier.object.RegisteringObjectCopier;

public class EclipseSerializerRegisteringCopier
implements RegisteringObjectCopier {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseSerializerRegisteringCopier.class);
    private final SerializerFoundation<?> foundation;
    private PersistenceManager<Binary> persistenceManager;
    private final SupportedChecker supportedChecker;
    private final WorkingCopyRegistry registry;

    public EclipseSerializerRegisteringCopier(WorkingCopyRegistry registry, SupportedChecker supportedChecker) {
        SerializerFoundation newFoundation = SerializerFoundation.New();
        newFoundation.registerCustomTypeHandler((PersistenceTypeHandler)BinaryHandlerImmutableCollectionsSet12.New());
        newFoundation.registerCustomTypeHandler((PersistenceTypeHandler)BinaryHandlerImmutableCollectionsList12.New());
        this.foundation = newFoundation;
        this.registry = registry;
        this.supportedChecker = supportedChecker;
    }

    public synchronized <T> T copy(T source) {
        return this.copy(source, false);
    }

    public synchronized void close() {
        if (this.persistenceManager != null) {
            this.persistenceManager.objectRegistry().clearAll();
            this.persistenceManager.close();
            this.persistenceManager = null;
        }
    }

    private void lazyInit() {
        if (this.persistenceManager == null) {
            XReference buffer = X.Reference(null);
            Serializer.Source source = () -> EclipseSerializerRegisteringCopier.lambda$lazyInit$0((Reference)buffer);
            Serializer.Target target = arg_0 -> ((Reference)buffer).set(arg_0);
            this.persistenceManager = ((SerializerFoundation)((SerializerFoundation)((SerializerFoundation)this.foundation.setPersistenceSource((PersistenceSource)source)).setPersistenceTarget((PersistenceTarget)target)).setTypeEvaluatorPersistable(a -> true)).createPersistenceManager();
        } else {
            this.persistenceManager.objectRegistry().truncateAll();
        }
    }

    @Override
    public synchronized <T> T copy(T source, boolean invertRegistering) {
        this.lazyInit();
        BinaryStorer.Default storer = (BinaryStorer.Default)this.persistenceManager.createStorer();
        PersistenceLoader loader = this.persistenceManager.createLoader();
        storer.store(source);
        HashMap originalObjects = new HashMap();
        storer.iterateMergeableEntries(originalObjects::put);
        storer.commit();
        Object returnValue = loader.get();
        Summarizer summarizer = new Summarizer();
        loader.iterateEntries((id, copiedObject) -> {
            if (copiedObject != null && !this.supportedChecker.isSupported(copiedObject.getClass())) {
                throw new DataTypeNotSupportedException(copiedObject.getClass());
            }
            summarizer.incrementCopiedObjectsCount();
            if (DataTypeUtil.isPrimitiveType(copiedObject.getClass())) {
                return;
            }
            Object originalObject = originalObjects.get(id);
            if (originalObject != null) {
                summarizer.incrementRegisteredObjectsCount();
                if (invertRegistering) {
                    this.registry.invertRegister(copiedObject, originalObject);
                } else {
                    this.registry.register(copiedObject, originalObject);
                }
            }
        });
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copied {} and registered {} objects.", (Object)summarizer.copiedObjectsCount, (Object)summarizer.registeredObjectsCount);
        }
        return (T)returnValue;
    }

    private static /* synthetic */ XGettingCollection lambda$lazyInit$0(Reference buffer) throws PersistenceExceptionTransfer {
        return X.Constant((Object)((Binary)buffer.get()));
    }

    private static class Summarizer {
        private long copiedObjectsCount = 0L;
        private long registeredObjectsCount = 0L;

        public void incrementCopiedObjectsCount() {
            ++this.copiedObjectsCount;
        }

        public void incrementRegisteredObjectsCount() {
            ++this.registeredObjectsCount;
        }
    }
}

