/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.auto;

import java.util.function.Supplier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.strategy.auto.AbstractAutoIdFinder;

public class AutoStringIdFinder
extends AbstractAutoIdFinder<String> {
    public AutoStringIdFinder(Supplier<Object> idGetter) {
        super(() -> (String)idGetter.get());
    }

    @Override
    protected String getNext(String oldId) {
        if (oldId == null) {
            return Long.toUnsignedString(0L);
        }
        try {
            long newId = Long.parseUnsignedLong(oldId);
            if (newId == Long.MAX_VALUE) {
                return Long.toUnsignedString(0L);
            }
            return Long.toUnsignedString(newId + 1L);
        }
        catch (NumberFormatException e) {
            return Long.toUnsignedString(0L);
        }
    }
}

