/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.importer;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.support.SimpleEclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.RecursiveWorkingCopier;

public class EclipseStoreDataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreDataImporter.class);
    private final EclipseStoreStorage eclipseStoreStorage;

    public EclipseStoreDataImporter(EclipseStoreStorage eclipseStoreStorage) {
        this.eclipseStoreStorage = eclipseStoreStorage;
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(EntityManagerFactory ... entityManagerFactories) {
        return this.importData(Arrays.stream(entityManagerFactories));
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(Iterable<EntityManagerFactory> entityManagerFactories) {
        return this.importData(StreamSupport.stream(entityManagerFactories.spliterator(), false));
    }

    public List<SimpleEclipseStoreRepository<?, ?>> importData(Stream<EntityManagerFactory> entityManagerFactories) {
        LOG.info("Start importing data from JPA Repositories to EclipseStore...");
        List<EntityManagerFactoryRepositoryListPair> allRepositories = entityManagerFactories.map(this::createEclipseStoreRepositoriesFromEntityManager).toList();
        LOG.info("Found {} repositories to export data from.", (Object)allRepositories.size());
        allRepositories.forEach(entityManagerFactoryRepositoryListPair -> entityManagerFactoryRepositoryListPair.classRepositoryPairs.forEach(classRepositoryPair -> this.copyData((EntityManagerFactoryRepositoryListPair)entityManagerFactoryRepositoryListPair, (ClassRepositoryPair)classRepositoryPair)));
        LOG.info("Done importing data from JPA Repositories to EclipseStore.");
        return allRepositories.stream().map(EntityManagerFactoryRepositoryListPair::classRepositoryPairs).flatMap(Collection::stream).map(ClassRepositoryPair::repository).collect(Collectors.toList());
    }

    private <T> void copyData(EntityManagerFactoryRepositoryListPair entityManagerFactoryRepositoryListPair, ClassRepositoryPair<T> classRepositoryPair) {
        String className = classRepositoryPair.domainClass.getName();
        LOG.info("Loading entities of {}...", (Object)className);
        try (EntityManager entityManager = entityManagerFactoryRepositoryListPair.entityManagerFactory.createEntityManager();){
            List existingEntitiesToExport = entityManager.createQuery("SELECT c FROM " + className + " c", classRepositoryPair.domainClass).getResultList();
            LOG.info("Loaded {} entities of type {} to export.", (Object)existingEntitiesToExport.size(), (Object)className);
            LOG.info("Saving {} entities of type {} to the EclipseStore Repository...", (Object)existingEntitiesToExport.size(), (Object)className);
            classRepositoryPair.repository.saveAll((Iterable)existingEntitiesToExport);
            LOG.info("Done saving entities of type {}. The EclipseStore now holds {} entities of that type.", (Object)className, (Object)classRepositoryPair.repository.count());
        }
    }

    private EntityManagerFactoryRepositoryListPair createEclipseStoreRepositoriesFromEntityManager(EntityManagerFactory entityManagerFactory) {
        ArrayList repositoryList = new ArrayList();
        entityManagerFactory.getMetamodel().getEntities().forEach(entityType -> this.createRepositoryForType((EntityType)entityType, repositoryList));
        return new EntityManagerFactoryRepositoryListPair(entityManagerFactory, repositoryList);
    }

    private <T> void createRepositoryForType(EntityType<T> entityType, List<ClassRepositoryPair<?>> repositoryList) {
        Class javaType = entityType.getJavaType();
        repositoryList.add(new ClassRepositoryPair<T>(javaType, this.createEclipseStoreRepo(javaType)));
    }

    private <T> SimpleEclipseStoreRepository<T, ?> createEclipseStoreRepo(Class<T> domainClass) {
        return new SimpleEclipseStoreRepository(this.eclipseStoreStorage, new RecursiveWorkingCopier<T>(domainClass, this.eclipseStoreStorage.getRegistry(), this.eclipseStoreStorage, this.eclipseStoreStorage, new SupportedChecker.Implementation()), domainClass);
    }

    private record ClassRepositoryPair<T>(Class<T> domainClass, SimpleEclipseStoreRepository<T, ?> repository) {
    }

    private record EntityManagerFactoryRepositoryListPair(EntityManagerFactory entityManagerFactory, List<ClassRepositoryPair<?>> classRepositoryPairs) {
    }
}

