/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.util;

import software.xdev.spring.data.eclipse.store.exceptions.NotComparableException;

public final class GenericObjectComparer {
    private GenericObjectComparer() {
    }

    public static <E> int compare(E o1, E o2) {
        Comparable comparableGeneric;
        Integer comparingResult;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable && (comparingResult = GenericObjectComparer.compareWithComparable(comparableGeneric = (Comparable)o1, o2)) != null) {
            return comparingResult;
        }
        throw new NotComparableException(String.format("Type %s is not comparable. Sorting is not available for that type.", o1.getClass().getSimpleName()));
    }

    private static <T extends Comparable, E> Integer compareWithComparable(T o1, E o2) {
        if (Comparable.class.isAssignableFrom(o2.getClass())) {
            return o1.compareTo(o2);
        }
        return null;
    }

    public static <E> boolean isLessThan(E o1, E o2) {
        return GenericObjectComparer.compare(o1, o2) < 0;
    }

    public static <E> boolean isLessOrEqualTo(E o1, E o2) {
        return GenericObjectComparer.compare(o1, o2) <= 0;
    }

    public static <E> boolean isGreaterThan(E o1, E o2) {
        return GenericObjectComparer.compare(o1, o2) > 0;
    }

    public static <E> boolean isGreaterOrEqualTo(E o1, E o2) {
        return GenericObjectComparer.compare(o1, o2) >= 0;
    }
}

