/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.executors;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.TypeInformation;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.ListQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.PageableQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.QueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.SingleOptionalQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.SingleQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;

public final class QueryExecutorCreator {
    private static final Logger LOG = LoggerFactory.getLogger(QueryExecutorCreator.class);

    private QueryExecutorCreator() {
    }

    public static <T> QueryExecutor<T> createQuery(TypeInformation<?> typeInformation, WorkingCopier<T> copier, Criteria<T> criteria, Sort sort) {
        if (typeInformation.isCollectionLike()) {
            if (typeInformation.getType().equals(Page.class)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Create PageableQuery");
                }
                return new PageableQueryExecutor<T>(copier, criteria, sort);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Create ListQuery");
            }
            return new ListQueryExecutor<T>(copier, criteria, sort);
        }
        if (typeInformation.getType().equals(Optional.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Create SingleOptionalQuery");
            }
            return new SingleOptionalQueryExecutor<T>(copier, criteria, sort);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create SingleQuery");
        }
        return new SingleQueryExecutor<T>(copier, criteria, sort);
    }
}

