/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.working;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.serializer.reference.Lazy;
import org.eclipse.serializer.reference.ObjectSwizzling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.exceptions.MergeFailedException;
import software.xdev.spring.data.eclipse.store.repository.PersistableChecker;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.WorkingCopyRegistry;
import software.xdev.spring.data.eclipse.store.repository.access.AccessHelper;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.lazy.SpringDataEclipseStoreLazy;
import software.xdev.spring.data.eclipse.store.repository.support.copier.DataTypeUtil;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdManager;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdManagerProvider;
import software.xdev.spring.data.eclipse.store.repository.support.copier.registering.RegisteringObjectCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.registering.RegisteringStorageToWorkingCopyCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.registering.RegisteringWorkingCopyToStorageCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.VersionManager;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.VersionManagerProvider;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.ChangedObjectCollector;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.HashSetChangedObjectCollector;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.HashSetMergedTargetsCollector;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.MergedTargetsCollector;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopierResult;

public class RecursiveWorkingCopier<T>
implements WorkingCopier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveWorkingCopier.class);
    private final RegisteringObjectCopier workingCopyToStorageCopier;
    private final RegisteringObjectCopier storageToWorkingCopyCopier;
    private final WorkingCopyRegistry registry;
    private final IdManagerProvider idManagerProvider;
    private final VersionManagerProvider versionManagerProvider;
    private final Class<T> domainClass;
    private final PersistableChecker persistableChecker;

    public RecursiveWorkingCopier(Class<T> domainClass, WorkingCopyRegistry registry, IdManagerProvider idManagerProvider, VersionManagerProvider versionManagerProvider, PersistableChecker persistableChecker, SupportedChecker supportedChecker, ObjectSwizzling objectSwizzling) {
        this.domainClass = domainClass;
        this.registry = registry;
        this.workingCopyToStorageCopier = new RegisteringWorkingCopyToStorageCopier(registry, supportedChecker, objectSwizzling, this);
        this.storageToWorkingCopyCopier = new RegisteringStorageToWorkingCopyCopier(registry, supportedChecker, objectSwizzling, this);
        this.idManagerProvider = idManagerProvider;
        this.versionManagerProvider = versionManagerProvider;
        this.persistableChecker = persistableChecker;
    }

    @Override
    public T copy(T objectToCopy) {
        T createdCopy = this.genericCopy(objectToCopy, false);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copied object of class {}", (Object)objectToCopy.getClass().getSimpleName());
        }
        return createdCopy;
    }

    @Override
    public <L extends Collection<T>> L copy(L objectCollectionToCopy) {
        L createdCopy = this.genericCopy(objectCollectionToCopy, false);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copied collection with class {}", (Object)objectCollectionToCopy.getClass().getSimpleName());
        }
        return createdCopy;
    }

    private <E> E genericCopy(E objectToCopy, boolean invertRegistry) {
        if (this.registry.getOriginalObjectFromWorkingCopy(objectToCopy) != null) {
            return objectToCopy;
        }
        return this.onlyCreateCopy(objectToCopy, invertRegistry);
    }

    @Override
    public WorkingCopierResult<T> mergeBack(T workingCopy) {
        HashSetChangedObjectCollector<T> changedObjectCollector = new HashSetChangedObjectCollector<T>(this.domainClass, this.persistableChecker);
        this.getOrCreateObjectForDatastore(workingCopy, true, new HashSetMergedTargetsCollector(), changedObjectCollector);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Merging back the working copy object of class {}", (Object)workingCopy.getClass().getSimpleName());
        }
        return changedObjectCollector.toResult();
    }

    public <E> E getOrCreateObjectForDatastore(E workingCopy, boolean mergeValues, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector) {
        Optional<?> existingEntity;
        if (workingCopy == null) {
            return null;
        }
        IdManager idManager = this.idManagerProvider.ensureIdManager(workingCopy.getClass());
        idManager.ensureId(workingCopy);
        VersionManager<?> versionManager = this.versionManagerProvider.ensureVersionManager(workingCopy.getClass());
        E originalObject = this.registry.getOriginalObjectFromWorkingCopy(workingCopy);
        if (originalObject != null) {
            versionManager.ensureSameVersion(workingCopy, originalObject);
            versionManager.incrementVersion(workingCopy);
            return this.mergeValueIfNeeded(workingCopy, mergeValues, alreadyMergedTargets, changedCollector, originalObject);
        }
        Object id = idManager.getId(workingCopy);
        if (id != null && (existingEntity = idManager.findById(id)).isPresent()) {
            versionManager.ensureSameVersion(workingCopy, existingEntity.get());
            versionManager.incrementVersion(workingCopy);
            return this.mergeValueIfNeeded(workingCopy, mergeValues, alreadyMergedTargets, changedCollector, existingEntity.get());
        }
        versionManager.incrementVersion(workingCopy);
        E objectForDatastore = this.genericCopy(workingCopy, true);
        this.mergeValues(workingCopy, objectForDatastore, alreadyMergedTargets, changedCollector);
        changedCollector.collectChangedObject(objectForDatastore);
        return objectForDatastore;
    }

    private <E> E mergeValueIfNeeded(E workingCopy, boolean mergeValues, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector, E existingEntity) {
        if (mergeValues) {
            this.mergeValues(workingCopy, existingEntity, alreadyMergedTargets, changedCollector);
        }
        changedCollector.collectChangedObject(existingEntity);
        return existingEntity;
    }

    @Override
    public T getOriginal(T workingCopy) {
        return this.registry.getOriginalObjectFromWorkingCopy(workingCopy);
    }

    private <E> void mergeValues(E sourceObject, E targetObject, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector) {
        if (sourceObject == targetObject || alreadyMergedTargets.isAlreadyMerged(targetObject) || targetObject == null) {
            return;
        }
        try {
            alreadyMergedTargets.collectMergedTarget(targetObject);
            if (sourceObject instanceof String || sourceObject instanceof SpringDataEclipseStoreLazy) {
                return;
            }
            Collection<Field> valuesToMerge = AccessHelper.getInheritedPrivateFieldsByName(sourceObject.getClass()).values();
            valuesToMerge.forEach(field -> this.mergeValueOfField(sourceObject, targetObject, (Field)field, alreadyMergedTargets, changedCollector));
        }
        catch (Exception e) {
            throw new MergeFailedException(sourceObject, targetObject, e);
        }
    }

    private <E> void mergeValueOfField(E sourceObject, E targetObject, Field field, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector) {
        try {
            int fieldModifiers = field.getModifiers();
            if (Modifier.isStatic(fieldModifiers)) {
                return;
            }
            try (FieldAccessModifier<E> fam = FieldAccessModifier.prepareForField(field, sourceObject);){
                Object valueOfSourceObject = fam.getValueOfField(sourceObject);
                Object valueOfTargetObject = fam.getValueOfField(targetObject);
                if (valueOfTargetObject != valueOfSourceObject) {
                    boolean targetObjectIsPartOfJavaPackage = targetObject.getClass().getPackageName().startsWith("java.");
                    changedCollector.collectChangedObject(targetObject);
                    if (DataTypeUtil.isPrimitiveType(field.getType())) {
                        if (!Objects.equals(valueOfTargetObject, valueOfSourceObject)) {
                            fam.writeValueOfField(targetObject, valueOfSourceObject, !targetObjectIsPartOfJavaPackage);
                        }
                    } else if (DataTypeUtil.isPrimitiveArray(valueOfSourceObject)) {
                        fam.writeValueOfField(targetObject, valueOfSourceObject, !targetObjectIsPartOfJavaPackage);
                    } else if (DataTypeUtil.isObjectArray(valueOfSourceObject)) {
                        ?[] newArray = this.createGenericObjectArray(valueOfSourceObject.getClass().getComponentType(), (Object[])valueOfSourceObject, alreadyMergedTargets, changedCollector);
                        fam.writeValueOfField(targetObject, newArray, !targetObjectIsPartOfJavaPackage);
                    } else if (DataTypeUtil.isSpringDataEclipseStoreLazy(valueOfSourceObject)) {
                        SpringDataEclipseStoreLazy<E> newLazy = this.createNewLazy((SpringDataEclipseStoreLazy)valueOfSourceObject, (SpringDataEclipseStoreLazy)valueOfTargetObject, alreadyMergedTargets, changedCollector);
                        fam.writeValueOfField(targetObject, newLazy, true);
                    } else {
                        this.mergeSimpleObjectValue(targetObject, alreadyMergedTargets, changedCollector, valueOfSourceObject, valueOfTargetObject, fam, targetObjectIsPartOfJavaPackage);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MergeFailedException(sourceObject, targetObject, e);
        }
    }

    private <E> void mergeSimpleObjectValue(E targetObject, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector, Object valueOfSourceObject, Object valueOfTargetObject, FieldAccessModifier<E> fam, boolean targetObjectIsPartOfJavaPackage) throws IllegalAccessException {
        Object originalValueObjectOfSource = this.getOrCreateObjectForDatastore(valueOfSourceObject, false, alreadyMergedTargets, changedCollector);
        if (valueOfTargetObject != originalValueObjectOfSource) {
            fam.writeValueOfField(targetObject, originalValueObjectOfSource, !targetObjectIsPartOfJavaPackage);
        }
        if (this.isSpecialCaseWhereOnlyAFullCopyWorks(valueOfSourceObject)) {
            fam.writeValueOfField(targetObject, this.onlyCreateCopy(valueOfSourceObject, true), !targetObjectIsPartOfJavaPackage);
        } else {
            this.mergeValues(valueOfSourceObject, originalValueObjectOfSource, alreadyMergedTargets, changedCollector);
        }
    }

    private <E> SpringDataEclipseStoreLazy<E> createNewLazy(SpringDataEclipseStoreLazy<E> oldLazy, SpringDataEclipseStoreLazy<?> newLazy, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector) {
        if (oldLazy.isLoaded()) {
            if (oldLazy.isOriginalObject()) {
                if (!newLazy.isStored()) {
                    return newLazy;
                }
                Object copyOfWrappedObject = this.getOrCreateObjectForDatastore(oldLazy.get(), true, alreadyMergedTargets, changedCollector);
                oldLazy.unlink();
                newLazy.unlink();
                return SpringDataEclipseStoreLazy.Internals.buildWithLazy(Lazy.Reference((Object)copyOfWrappedObject));
            }
            Object copyOfWrappedObject = this.getOrCreateObjectForDatastore(oldLazy.get(), true, alreadyMergedTargets, changedCollector);
            oldLazy.unlink();
            newLazy.unlink();
            return SpringDataEclipseStoreLazy.build(copyOfWrappedObject);
        }
        oldLazy.unlink();
        return newLazy.copyWithReference();
    }

    private boolean isSpecialCaseWhereOnlyAFullCopyWorks(Object valueOfSourceObject) {
        return valueOfSourceObject != null && (valueOfSourceObject.getClass().isAssignableFrom(HashMap.class) || valueOfSourceObject.getClass().isAssignableFrom(LinkedHashMap.class) || valueOfSourceObject.getClass().isAssignableFrom(Hashtable.class) || valueOfSourceObject.getClass().isAssignableFrom(TreeSet.class) || valueOfSourceObject.getClass().isAssignableFrom(TreeMap.class) || valueOfSourceObject.getClass().isAssignableFrom(IdentityHashMap.class));
    }

    private <E> E[] createGenericObjectArray(Class<E> clazz, Object[] valueOfSourceObjectArray, MergedTargetsCollector alreadyMergedTargets, ChangedObjectCollector changedCollector) {
        Object[] newArray = (Object[])Array.newInstance(clazz, valueOfSourceObjectArray.length);
        for (int i = 0; i < valueOfSourceObjectArray.length; ++i) {
            newArray[i] = this.getOrCreateObjectForDatastore(valueOfSourceObjectArray[i], true, alreadyMergedTargets, changedCollector);
        }
        return newArray;
    }

    @Override
    public <E> E onlyCreateCopy(E objectToCopy, boolean invertRegistry) {
        if (invertRegistry) {
            return this.workingCopyToStorageCopier.copy(objectToCopy);
        }
        return this.storageToWorkingCopyCopier.copy(objectToCopy);
    }

    @Override
    public void deregister(T workingCopy) {
        this.registry.deregister(workingCopy);
    }
}

