/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.version.incrementer;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.UUID;
import software.xdev.spring.data.eclipse.store.exceptions.IdGeneratorNotSupportedException;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.incrementer.IntegerVersionIncrementer;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.incrementer.LongVersionIncrementer;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.incrementer.StringVersionIncrementer;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.incrementer.UUIDVersionIncrementer;

public interface VersionIncrementer<VERSION> {
    public VERSION increment(VERSION var1);

    public static VersionIncrementer<?> createVersionIncrementer(Field versionField) {
        Objects.requireNonNull(versionField);
        if (Integer.class.isAssignableFrom(versionField.getType()) || Integer.TYPE.isAssignableFrom(versionField.getType())) {
            return new IntegerVersionIncrementer();
        }
        if (versionField.getType().equals(String.class)) {
            return new StringVersionIncrementer();
        }
        if (versionField.getType().equals(UUID.class)) {
            return new UUIDVersionIncrementer();
        }
        if (Long.class.isAssignableFrom(versionField.getType()) || Long.TYPE.isAssignableFrom(versionField.getType())) {
            return new LongVersionIncrementer();
        }
        throw new IdGeneratorNotSupportedException("@Version with type %s is not supported.".formatted(versionField.getType().getSimpleName()));
    }
}

