/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.version;

import jakarta.persistence.OptimisticLockException;
import java.lang.reflect.Field;
import java.util.Optional;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.exceptions.InvalidVersionException;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.support.AnnotatedFieldFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.EntityVersionIncrementer;

public class VersionManager<T> {
    private final Optional<Field> versionField;
    private final EntityVersionIncrementer<T> entityVersionIncrementer;

    public VersionManager(Class<T> entityClass, EntityVersionIncrementer<T> entityVersionIncrementer) {
        this.versionField = AnnotatedFieldFinder.findVersionField(entityClass);
        this.entityVersionIncrementer = entityVersionIncrementer;
    }

    public void incrementVersion(T entity) {
        this.entityVersionIncrementer.incrementVersion(entity);
    }

    public void ensureSameVersion(T workingCopy, T original) {
        if (this.versionField.isPresent() && original != null) {
            try (FieldAccessModifier<T> fam1 = FieldAccessModifier.prepareForField(this.versionField.get(), original);){
                Object originalValue = fam1.getValueOfField(original);
                if (originalValue == null) {
                    return;
                }
                try (FieldAccessModifier<T> fam2 = FieldAccessModifier.prepareForField(this.versionField.get(), workingCopy);){
                    Object workingCopyValue = fam2.getValueOfField(workingCopy);
                    if (workingCopyValue == null) {
                        throw new InvalidVersionException("Trying to an existing versioned entity with an entity without version (version is null) is not permitted.");
                    }
                    if (!workingCopyValue.equals(originalValue)) {
                        throw new OptimisticLockException("Versions are not equal: original version=\"%s\" new version=\"%s\"".formatted(originalValue, workingCopyValue));
                    }
                }
            }
            catch (OptimisticLockException | InvalidVersionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FieldAccessReflectionException(this.versionField.get(), e);
            }
        }
    }
}

