/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.version;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.exceptions.IdFieldFinalException;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.EntityVersionIncrementer;
import software.xdev.spring.data.eclipse.store.repository.support.copier.version.incrementer.VersionIncrementer;

public class SimpleEntityVersionIncrementer<T, VERSION>
implements EntityVersionIncrementer<T> {
    private final VersionIncrementer<VERSION> versionIncrementer;
    private final Field versionField;

    public SimpleEntityVersionIncrementer(Field versionField, VersionIncrementer<VERSION> versionIncrementer) {
        this.versionField = versionField;
        this.versionIncrementer = versionIncrementer;
        this.checkIfVersionFieldIsFinal();
    }

    private void checkIfVersionFieldIsFinal() {
        int fieldModifiers = this.versionField.getModifiers();
        if (Modifier.isFinal(fieldModifiers)) {
            throw new IdFieldFinalException(String.format("Field %s is final and cannot be modified. Version fields must not be final.", this.versionField.getName()));
        }
    }

    @Override
    public void incrementVersion(T objectToSetVersionIn) {
        try (FieldAccessModifier<T> fam = FieldAccessModifier.prepareForField(this.versionField, objectToSetVersionIn);){
            Object existingVersion = fam.getValueOfField(objectToSetVersionIn);
            Object newVersion = this.versionIncrementer.increment(existingVersion);
            fam.writeValueOfField(objectToSetVersionIn, newVersion, true);
        }
        catch (Exception e) {
            throw new FieldAccessReflectionException(this.versionField, e);
        }
    }
}

