/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.registering;

import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.binary.types.BinaryStorer;
import org.eclipse.serializer.persistence.types.PersistenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.spring.data.eclipse.store.exceptions.DataTypeNotSupportedException;
import software.xdev.spring.data.eclipse.store.repository.SupportedChecker;
import software.xdev.spring.data.eclipse.store.repository.support.copier.DataTypeUtil;
import software.xdev.spring.data.eclipse.store.repository.support.copier.registering.RegisteringWorkingCopyAndOriginal;

public class EclipseSerializerRegisteringCopier
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseSerializerRegisteringCopier.class);
    private final Queue<PersistenceManager<Binary>> persistenceManagers;
    private final Supplier<PersistenceManager<Binary>> persistenceManagerSupplier;
    private final SupportedChecker supportedChecker;
    private final RegisteringWorkingCopyAndOriginal register;

    public EclipseSerializerRegisteringCopier(SupportedChecker supportedChecker, RegisteringWorkingCopyAndOriginal register, Supplier<PersistenceManager<Binary>> persistenceManagerSupplier) {
        this.supportedChecker = supportedChecker;
        this.register = register;
        this.persistenceManagerSupplier = persistenceManagerSupplier;
        this.persistenceManagers = new ConcurrentLinkedQueue<PersistenceManager<Binary>>();
    }

    private PersistenceManager<Binary> ensurePersistenceManager() {
        PersistenceManager<Binary> readyToUsePersistenceManager = this.persistenceManagers.poll();
        if (readyToUsePersistenceManager == null) {
            return this.persistenceManagerSupplier.get();
        }
        return readyToUsePersistenceManager;
    }

    private void returnPersistenceManagerForFutureUses(PersistenceManager<Binary> usedPersistenceManager) {
        this.persistenceManagers.add(usedPersistenceManager);
    }

    @Override
    public void close() {
        PersistenceManager<Binary> usedPersistenceManager = this.persistenceManagers.poll();
        do {
            usedPersistenceManager.objectRegistry().clearAll();
            usedPersistenceManager.close();
        } while ((usedPersistenceManager = this.persistenceManagers.poll()) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T source) {
        PersistenceManager<Binary> persistenceManager = this.ensurePersistenceManager();
        try {
            T t = this.copy(source, persistenceManager);
            return t;
        }
        finally {
            this.returnPersistenceManagerForFutureUses(persistenceManager);
        }
    }

    private <T> T copy(T source, PersistenceManager<Binary> persistenceManager) {
        persistenceManager.objectRegistry().truncateAll();
        BinaryStorer.Default storer = (BinaryStorer.Default)persistenceManager.createStorer();
        PersistenceLoader loader = persistenceManager.createLoader();
        storer.store(source);
        HashMap originalObjects = new HashMap();
        storer.iterateMergeableEntries(originalObjects::put);
        storer.commit();
        Object returnValue = loader.get();
        Summarizer summarizer = new Summarizer();
        loader.iterateEntries((id, copiedObject) -> {
            if (copiedObject != null && !this.supportedChecker.isSupported(copiedObject.getClass())) {
                throw new DataTypeNotSupportedException(copiedObject.getClass());
            }
            summarizer.incrementCopiedObjectsCount();
            if (DataTypeUtil.isPrimitiveType(copiedObject.getClass())) {
                return;
            }
            Object originalObject = originalObjects.get(id);
            if (originalObject != null) {
                summarizer.incrementRegisteredObjectsCount();
                this.register.register(copiedObject, originalObject);
            }
        });
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copied {} and registered {} objects.", (Object)summarizer.copiedObjectsCount, (Object)summarizer.registeredObjectsCount);
        }
        return (T)returnValue;
    }

    private static class Summarizer {
        private long copiedObjectsCount = 0L;
        private long registeredObjectsCount = 0L;

        public void incrementCopiedObjectsCount() {
            ++this.copiedObjectsCount;
        }

        public void incrementRegisteredObjectsCount() {
            ++this.registeredObjectsCount;
        }
    }
}

