/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier.id;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.exceptions.NoIdFieldFoundException;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.support.AnnotatedFieldFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.EntityGetterById;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdGetter;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdSetter;

public class IdManager<T, ID>
implements EntityGetterById<T, ID>,
IdGetter<T, ID> {
    private final Class<T> classWithId;
    private final IdSetter<T> idSetter;
    private final Optional<Field> idField;
    private final EclipseStoreStorage storage;

    public IdManager(Class<T> classWithId, IdSetter<T> idSetter, EclipseStoreStorage storage) {
        this.classWithId = classWithId;
        this.idSetter = idSetter;
        this.storage = storage;
        this.idField = AnnotatedFieldFinder.findIdField(this.classWithId);
    }

    public Field ensureIdField() {
        if (this.idField.isEmpty()) {
            throw new NoIdFieldFoundException(String.format("Could not find id field in class %s", this.classWithId.getSimpleName()));
        }
        return this.idField.get();
    }

    @Override
    public Optional<T> findById(@Nonnull ID id) {
        this.ensureIdField();
        return this.storage.getReadWriteLock().read(() -> this.storage.getEntityProvider(this.classWithId).stream().filter(entity -> id.equals(this.getId(entity))).findAny());
    }

    public List<T> findAllById(@Nonnull Iterable<ID> idsToFind) {
        this.ensureIdField();
        return this.storage.getReadWriteLock().read(() -> this.storage.getEntityProvider(this.classWithId).stream().filter(entity -> {
            Object idOfEntity = this.getId(entity);
            return StreamSupport.stream(idsToFind.spliterator(), false).anyMatch(idToFind -> idToFind.equals(idOfEntity));
        }).toList());
    }

    public IdSetter<T> getIdSetter() {
        return this.idSetter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ID getId(T entity) {
        if (!this.hasIdField()) return null;
        try (FieldAccessModifier<T> fam = FieldAccessModifier.prepareForField(this.ensureIdField(), entity);){
            Object object = fam.getValueOfField(entity);
            return (ID)object;
        }
        catch (Exception e) {
            throw new FieldAccessReflectionException(this.ensureIdField(), e);
        }
    }

    public boolean hasIdField() {
        return this.idField.isPresent();
    }

    public void ensureId(T objectToSetIdIn) {
        this.getIdSetter().ensureId(objectToSetIdIn);
    }

    public <S extends T> void checkIds(Collection<S> entities) {
        Optional<Object> entityWithNullId;
        if (!this.hasIdField()) {
            return;
        }
        List<Object> ids = entities.stream().map(entity -> this.getId(entity)).toList();
        if (!this.getIdSetter().isAutomaticSetter() && ids.contains(null) && (entityWithNullId = entities.stream().filter(entity -> this.getId(entity) == null).findAny()).isPresent()) {
            throw new IllegalArgumentException("Invalid ID (null) for entity " + entityWithNullId);
        }
        List<Object> multipleEqualIds = ids.stream().filter(id -> Collections.frequency(ids, id) > 1).toList();
        if (!multipleEqualIds.isEmpty()) {
            throw new IllegalArgumentException("Same ID %s is set multiple times in one save call ".formatted(multipleEqualIds.get(0)));
        }
    }
}

