/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.persistence.Id;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.annotation.Version;
import software.xdev.spring.data.eclipse.store.repository.access.AccessHelper;

public final class AnnotatedFieldFinder {
    private AnnotatedFieldFinder() {
    }

    public static Optional<Field> findIdField(Class<?> domainClass) {
        return AnnotatedFieldFinder.findAnnotatedField(domainClass, List.of(Id.class, org.springframework.data.annotation.Id.class));
    }

    public static Optional<Field> findVersionField(Class<?> domainClass) {
        return AnnotatedFieldFinder.findAnnotatedField(domainClass, List.of(jakarta.persistence.Version.class, Version.class));
    }

    public static Optional<Field> findAnnotatedField(Class<?> domainClass, Collection<Class<? extends Annotation>> annotations) {
        Collection<Field> classFields = AccessHelper.getInheritedPrivateFieldsByName(domainClass).values();
        for (Field currentField : classFields) {
            for (Class<? extends Annotation> annotation : annotations) {
                if (currentField.getAnnotationsByType(annotation).length <= 0) continue;
                return Optional.of(currentField);
            }
        }
        return Optional.empty();
    }
}

