/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.query.criteria;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import software.xdev.spring.data.eclipse.store.repository.query.ReflectedField;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.CriteriaAndNode;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.CriteriaOrNode;
import software.xdev.spring.data.eclipse.store.util.GenericObjectComparer;

public abstract class AbstractCriteriaNode<T>
implements Criteria<T> {
    private final ReflectedField<T, ?> field;
    final LinkedHashSet<Predicate<T>> predicates = new LinkedHashSet();

    protected AbstractCriteriaNode(@Nullable ReflectedField<T, ?> field) {
        this.field = field;
    }

    public AbstractCriteriaNode<T> and(ReflectedField<T, ?> field) {
        return new CriteriaAndNode<T>(this, Objects.requireNonNull(field));
    }

    public AbstractCriteriaNode<T> orOperator(AbstractCriteriaNode<T> criteria) {
        Objects.requireNonNull(criteria);
        return new CriteriaOrNode<T>(this, criteria);
    }

    public AbstractCriteriaNode<T> is(@Nullable Object value) {
        this.predicates.add(entity -> {
            Object fieldValue = Objects.requireNonNull(this.field).readValue(entity);
            return Objects.equals(fieldValue, value);
        });
        return this;
    }

    public AbstractCriteriaNode<T> ne(@Nullable Object value) {
        this.predicates.add(entity -> {
            Object fieldValue = Objects.requireNonNull(this.field).readValue(entity);
            return !Objects.equals(fieldValue, value);
        });
        return this;
    }

    public AbstractCriteriaNode<T> lt(Object value) {
        Objects.requireNonNull(value);
        this.predicates.add(entity -> GenericObjectComparer.isLessThan(Objects.requireNonNull(this.field).readValue(entity), value));
        return this;
    }

    public AbstractCriteriaNode<T> lte(Object value) {
        Objects.requireNonNull(value);
        this.predicates.add(entity -> GenericObjectComparer.isLessOrEqualTo(Objects.requireNonNull(this.field).readValue(entity), value));
        return this;
    }

    public AbstractCriteriaNode<T> gt(Object value) {
        Objects.requireNonNull(value);
        this.predicates.add(entity -> GenericObjectComparer.isGreaterThan(Objects.requireNonNull(this.field).readValue(entity), value));
        return this;
    }

    public AbstractCriteriaNode<T> gte(Object value) {
        Objects.requireNonNull(value);
        this.predicates.add(entity -> GenericObjectComparer.isGreaterOrEqualTo(Objects.requireNonNull(this.field).readValue(entity), value));
        return this;
    }

    public AbstractCriteriaNode<T> between(Object minValue, Object maxValue) {
        Objects.requireNonNull(minValue);
        Objects.requireNonNull(maxValue);
        this.predicates.add(entity -> {
            Object value = Objects.requireNonNull(this.field).readValue(entity);
            return GenericObjectComparer.isLessOrEqualTo(value, maxValue) && GenericObjectComparer.isGreaterOrEqualTo(value, minValue);
        });
        return this;
    }

    public AbstractCriteriaNode<T> in(Streamable<?> values) {
        this.predicates.add(entity -> {
            if (values == null) {
                return false;
            }
            return values.toSet().contains(Objects.requireNonNull(this.field).readValue(entity));
        });
        return this;
    }

    public AbstractCriteriaNode<T> nin(Streamable<?> values) {
        this.predicates.add(entity -> {
            if (values == null) {
                return true;
            }
            return !values.toSet().contains(Objects.requireNonNull(this.field).readValue(entity));
        });
        return this;
    }

    public AbstractCriteriaNode<T> exists(boolean value) {
        this.predicates.add(entity -> value == (Objects.requireNonNull(this.field).readValue(entity) != null));
        return this;
    }

    public AbstractCriteriaNode<T> like(String like) {
        String completeRegex = AbstractCriteriaNode.sqlLikeStringToRegex(like);
        this.predicates.add(entity -> {
            String fieldValue = (String)Objects.requireNonNull(this.field).readValue(entity);
            return fieldValue != null && fieldValue.toUpperCase().matches(completeRegex);
        });
        return this;
    }

    private static String sqlLikeStringToRegex(String like) {
        String regex = like.toUpperCase();
        regex = regex.replace(".", "\\.");
        regex = regex.replace("_", ".");
        return regex.replace("%", ".*");
    }

    public AbstractCriteriaNode<T> startWith(String startString) {
        return this.like(startString + "%");
    }

    public AbstractCriteriaNode<T> endWith(String endString) {
        return this.like("%" + endString);
    }

    public AbstractCriteriaNode<T> containing(String containedString) {
        return this.like("%" + containedString + "%");
    }

    public AbstractCriteriaNode<T> notLike(String notLikeString) {
        String completeRegex = AbstractCriteriaNode.sqlLikeStringToRegex(notLikeString);
        this.predicates.add(entity -> {
            String fieldValue = (String)Objects.requireNonNull(this.field).readValue(entity);
            return fieldValue != null && !fieldValue.toUpperCase().matches(completeRegex);
        });
        return this;
    }

    public AbstractCriteriaNode<T> notContaining(String containedString) {
        return this.notLike("%" + containedString + "%");
    }
}

