/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support.copier;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public final class DataTypeUtil {
    private static final Set<Class<?>> WRAPPER_TYPES = Set.of(Integer.class, Byte.class, Character.class, Boolean.class, Double.class, Float.class, Long.class, Short.class, Void.class, String.class);

    private DataTypeUtil() {
    }

    public static boolean isObjectArray(Object obj) {
        return obj instanceof Object[];
    }

    public static boolean isPrimitiveArray(Object obj) {
        return obj instanceof boolean[] || obj instanceof byte[] || obj instanceof short[] || obj instanceof char[] || obj instanceof int[] || obj instanceof long[] || obj instanceof float[] || obj instanceof double[];
    }

    public static <T> boolean isPrimitiveType(@Nonnull Class<T> source) {
        Objects.requireNonNull(source);
        if (WRAPPER_TYPES.contains(source)) {
            return true;
        }
        return source.isPrimitive();
    }
}

