/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import software.xdev.spring.data.eclipse.store.exceptions.FieldAccessReflectionException;
import software.xdev.spring.data.eclipse.store.exceptions.NoIdFieldFoundException;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.access.modifier.FieldAccessModifier;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListCrudRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreListPagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStorePagingAndSortingRepositoryRepository;
import software.xdev.spring.data.eclipse.store.repository.interfaces.EclipseStoreRepository;
import software.xdev.spring.data.eclipse.store.repository.query.criteria.Criteria;
import software.xdev.spring.data.eclipse.store.repository.query.executors.ListQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.query.executors.PageableQueryExecutor;
import software.xdev.spring.data.eclipse.store.repository.support.IdFieldFinder;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopier;
import software.xdev.spring.data.eclipse.store.repository.support.copier.working.WorkingCopierResult;

public class SimpleEclipseStoreRepository<T, ID>
implements EclipseStoreRepository<T, ID>,
EclipseStorePagingAndSortingRepositoryRepository<T, ID>,
EclipseStoreListPagingAndSortingRepositoryRepository<T, ID>,
EclipseStoreCrudRepository<T, ID>,
EclipseStoreListCrudRepository<T, ID> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleEclipseStoreRepository.class);
    private final EclipseStoreStorage storage;
    private final Class<T> domainClass;
    private final WorkingCopier<T> copier;
    private Field idField;

    public SimpleEclipseStoreRepository(EclipseStoreStorage storage, WorkingCopier<T> copier, Class<T> domainClass) {
        this.storage = storage;
        this.domainClass = domainClass;
        this.storage.registerEntity(domainClass);
        this.copier = copier;
    }

    public Field getIdField() {
        if (this.idField == null) {
            Optional<Field> foundIdField = IdFieldFinder.findIdField(this.domainClass);
            if (foundIdField.isEmpty()) {
                throw new NoIdFieldFoundException(String.format("Could not find id field in class %s", this.domainClass.getSimpleName()));
            }
            this.idField = foundIdField.get();
        }
        return this.idField;
    }

    public synchronized <S extends T> List<S> saveBulk(Collection<S> entities) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving {} entities...", (Object)entities.size());
        }
        List<WorkingCopierResult> results = this.checkEntityForNull(entities).stream().map(this.copier::mergeBack).toList();
        Set<Object> nonEntitiesToStore = results.stream().map(WorkingCopierResult::nonEntitiesToStore).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        List entitiesToStore = results.stream().map(WorkingCopierResult::originalEntities).flatMap(Collection::stream).toList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collected {} non-entities to store.", (Object)nonEntitiesToStore.size());
        }
        this.storage.store(nonEntitiesToStore, this.domainClass, entitiesToStore);
        return entitiesToStore;
    }

    @Nonnull
    public synchronized <S extends T> S save(@Nonnull S entity) {
        return this.saveBulk(List.of(this.checkEntityForNull(entity))).get(0);
    }

    private <S> S checkEntityForNull(S entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity must not be null");
        }
        return entity;
    }

    @Nonnull
    public <S extends T> List<S> saveAll(@Nonnull Iterable<S> entities) {
        ArrayList list = new ArrayList();
        this.checkEntityForNull(entities).forEach(list::add);
        return this.saveBulk(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Optional<T> findById(@Nonnull ID id) {
        Iterator<T> iterator = this.storage.getEntityList(this.domainClass).iterator();
        while (iterator.hasNext()) {
            T entity = iterator.next();
            try {
                FieldAccessModifier<T> fam = FieldAccessModifier.makeFieldReadable(this.getIdField(), entity);
                try {
                    if (!id.equals(fam.getValueOfField(entity))) continue;
                    Optional<T> optional = Optional.of(this.copier.copy(entity));
                    return optional;
                }
                finally {
                    if (fam == null) continue;
                    fam.close();
                }
            }
            catch (Exception e) {
                throw new FieldAccessReflectionException(String.format("Could not read field %s", this.getIdField().getName()), e);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsById(@Nonnull ID id) {
        Iterator<T> iterator = this.storage.getEntityList(this.domainClass).iterator();
        while (iterator.hasNext()) {
            T entity = iterator.next();
            try {
                FieldAccessModifier<T> fam = FieldAccessModifier.makeFieldReadable(this.getIdField(), entity);
                try {
                    if (!id.equals(fam.getValueOfField(entity))) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (fam == null) continue;
                    fam.close();
                }
            }
            catch (Exception e) {
                throw new FieldAccessReflectionException(String.format("Could not read field %s", this.getIdField().getName()), e);
            }
        }
        return false;
    }

    @Nonnull
    public List<T> findAll() {
        return this.copier.copy(this.storage.getEntityList(this.domainClass)).stream().toList();
    }

    @Nonnull
    public List<T> findAllById(@Nonnull Iterable<ID> ids) {
        ArrayList<T> foundEntities = new ArrayList<T>();
        for (T entity : this.storage.getEntityList(this.domainClass)) {
            try {
                FieldAccessModifier<T> fam = FieldAccessModifier.makeFieldReadable(this.getIdField(), entity);
                try {
                    for (ID id : ids) {
                        if (!id.equals(fam.getValueOfField(entity))) continue;
                        foundEntities.add(this.copier.copy(entity));
                    }
                }
                finally {
                    if (fam == null) continue;
                    fam.close();
                }
            }
            catch (Exception e) {
                throw new FieldAccessReflectionException(String.format("Could not read field %s", this.getIdField().getName()), e);
            }
        }
        return foundEntities;
    }

    public long count() {
        return this.storage.getEntityList(this.domainClass).size();
    }

    public void deleteById(@Nonnull ID id) {
        Optional<Object> byId = this.findById(id);
        byId.ifPresent(this::delete);
    }

    public void delete(@Nonnull T entity) {
        this.storage.delete(this.domainClass, this.copier.getOriginal(entity));
        this.copier.deregister(entity);
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        for (ID id : ids) {
            this.deleteById(id);
        }
    }

    public void deleteAll(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.storage.deleteAll(this.domainClass);
    }

    @Nonnull
    public List<T> findAll(@Nonnull Sort sort) {
        ListQueryExecutor<T> query = new ListQueryExecutor<T>(this.copier, Criteria.createNoCriteria());
        return query.execute((Class)this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{sort});
    }

    @Nonnull
    public Page<T> findAll(@Nonnull Pageable pageable) {
        PageableQueryExecutor<T> pageableQuery = new PageableQueryExecutor<T>(this.copier, Criteria.createNoCriteria(), null);
        return pageableQuery.execute(this.domainClass, this.storage.getEntityList(this.domainClass), new Object[]{pageable});
    }
}

