/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository.support;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.stereotype.Component;
import software.xdev.spring.data.eclipse.store.repository.EclipseStoreStorage;
import software.xdev.spring.data.eclipse.store.repository.support.EclipseStoreRepositoryFactory;

@ComponentScan(value={"software.xdev.spring.data.eclipse.store.repository", "org.eclipse.store.integrations.spring.boot.types"})
@Component
public class EclipseStoreRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private final EclipseStoreStorage storage;

    public EclipseStoreRepositoryFactoryBean(Class<? extends T> repositoryInterface, EclipseStoreStorage storage) {
        super(repositoryInterface);
        this.storage = storage;
    }

    @Nonnull
    protected RepositoryFactorySupport createRepositoryFactory() {
        return new EclipseStoreRepositoryFactory(this.storage);
    }
}

