/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.serializer.persistence.binary.jdk17.java.util.BinaryHandlerImmutableCollectionsList12;
import org.eclipse.serializer.persistence.binary.jdk17.java.util.BinaryHandlerImmutableCollectionsSet12;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.persistence.types.Storer;
import org.eclipse.store.integrations.spring.boot.types.EclipseStoreProvider;
import org.eclipse.store.integrations.spring.boot.types.configuration.ConfigurationPair;
import org.eclipse.store.integrations.spring.boot.types.configuration.EclipseStoreProperties;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.eclipse.store.storage.types.StorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import software.xdev.spring.data.eclipse.store.core.IdentitySet;
import software.xdev.spring.data.eclipse.store.exceptions.AlreadyRegisteredException;
import software.xdev.spring.data.eclipse.store.repository.EntityListProvider;
import software.xdev.spring.data.eclipse.store.repository.EntitySetCollector;
import software.xdev.spring.data.eclipse.store.repository.IdSetterProvider;
import software.xdev.spring.data.eclipse.store.repository.PersistableChecker;
import software.xdev.spring.data.eclipse.store.repository.RelayedPersistenceChecker;
import software.xdev.spring.data.eclipse.store.repository.Root;
import software.xdev.spring.data.eclipse.store.repository.WorkingCopyRegistry;
import software.xdev.spring.data.eclipse.store.repository.support.copier.id.IdSetter;
import software.xdev.spring.data.eclipse.store.repository.support.reposyncer.RepositorySynchronizer;
import software.xdev.spring.data.eclipse.store.repository.support.reposyncer.SimpleRepositorySynchronizer;

@Component
public class EclipseStoreStorage
implements EntityListProvider,
IdSetterProvider,
PersistableChecker {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseStoreStorage.class);
    private final Map<Class<?>, String> entityClassToRepositoryName = new HashMap();
    private final Map<Class<?>, IdSetter<?>> entityClassToIdSetter = new HashMap();
    private EntitySetCollector entitySetCollector;
    private PersistableChecker persistenceChecker;
    private final EclipseStoreProperties storeConfiguration;
    private final EclipseStoreProvider storeProvider;
    private StorageManager storageManager;
    private Root root;
    private final WorkingCopyRegistry registry = new WorkingCopyRegistry();
    private RepositorySynchronizer repositorySynchronizer;

    @Autowired
    public EclipseStoreStorage(EclipseStoreProperties storeConfiguration, EclipseStoreProvider storeProvider) {
        this.storeConfiguration = storeConfiguration;
        this.storeProvider = storeProvider;
    }

    private synchronized StorageManager getInstanceOfStorageManager() {
        this.ensureEntitiesInRoot();
        return this.storageManager;
    }

    public WorkingCopyRegistry getRegistry() {
        return this.registry;
    }

    private synchronized void ensureEntitiesInRoot() {
        if (this.storageManager == null) {
            LOG.info("Starting storage...");
            this.root = new Root();
            EmbeddedStorageFoundation embeddedStorageFoundation = this.storeProvider.createStorageFoundation(this.storeConfiguration, new ConfigurationPair[0]);
            embeddedStorageFoundation.registerTypeHandler((PersistenceTypeHandler)BinaryHandlerImmutableCollectionsSet12.New());
            embeddedStorageFoundation.registerTypeHandler((PersistenceTypeHandler)BinaryHandlerImmutableCollectionsList12.New());
            this.storageManager = embeddedStorageFoundation.start((Object)this.root);
            this.persistenceChecker = new RelayedPersistenceChecker(embeddedStorageFoundation);
            this.initRoot();
            Integer entitySum = this.root.getEntityLists().values().stream().map(IdentitySet::size).reduce(0, Integer::sum);
            LOG.info("Storage started with {} entity lists and {} entities.", (Object)this.root.getEntityLists().size(), (Object)entitySum);
        }
    }

    private void initRoot() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing entity lists...");
        }
        this.repositorySynchronizer = new SimpleRepositorySynchronizer(this.entityClassToRepositoryName, this.root);
        boolean entityListMustGetStored = false;
        for (String entityName : this.entityClassToRepositoryName.values()) {
            if (this.root.getEntityLists().containsKey(entityName)) continue;
            this.root.getEntityLists().put(entityName, new IdentitySet());
            entityListMustGetStored = true;
        }
        if (entityListMustGetStored) {
            this.storageManager.store(this.root.getEntityLists());
        }
        this.entitySetCollector = new EntitySetCollector(this.root.getEntityLists(), this.entityClassToRepositoryName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done initializing entity lists.");
        }
    }

    public synchronized <T> void registerEntity(Class<T> classToRegister) {
        String entityName = this.getEntityName(classToRegister);
        if (this.entityClassToRepositoryName.containsKey(classToRegister)) {
            throw new AlreadyRegisteredException(entityName);
        }
        this.entityClassToRepositoryName.put(classToRegister, entityName);
    }

    private <T> String getEntityName(Class<T> classToRegister) {
        return classToRegister.getName();
    }

    @Override
    public synchronized <T> IdentitySet<T> getEntityList(Class<T> clazz) {
        this.ensureEntitiesInRoot();
        return this.root.getEntityLists().get(this.getEntityName(clazz));
    }

    public synchronized <T> void store(Collection<Object> nonEntitiesToStore, Class<T> clazz, Iterable<T> entitiesToStore) {
        Collection<Object> entitiesAndPossiblyNonEntitiesToStore = this.collectRootEntitiesToStore(clazz, entitiesToStore);
        entitiesAndPossiblyNonEntitiesToStore.addAll(nonEntitiesToStore);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collected {} objects store in total.", (Object)entitiesAndPossiblyNonEntitiesToStore.size());
        }
        Storer storer = this.storageManager.createLazyStorer();
        storer.storeAll(entitiesAndPossiblyNonEntitiesToStore);
        storer.commit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done storing {} entities...", (Object)entitiesAndPossiblyNonEntitiesToStore.size());
        }
    }

    private <T> Collection<Object> collectRootEntitiesToStore(Class<T> clazz, Iterable<T> entitiesToStore) {
        List<IdentitySet<Object>> entityLists = this.entitySetCollector.getRelatedIdentitySets(clazz);
        ArrayList<Object> objectsToStore = new ArrayList<Object>();
        for (Object entityToStore : entitiesToStore) {
            entityLists.forEach(relatedIdentitySet -> {
                if (!relatedIdentitySet.contains(entityToStore)) {
                    relatedIdentitySet.add(entityToStore);
                    objectsToStore.add(relatedIdentitySet.getInternalMap());
                }
            });
            objectsToStore.add(entityToStore);
            this.repositorySynchronizer.syncAndReturnChangedObjectLists(entityToStore).forEach(changedEntityList -> objectsToStore.add(changedEntityList.getInternalMap()));
        }
        return objectsToStore;
    }

    public synchronized <T> void delete(Class<T> clazz, T objectToRemove) {
        List<IdentitySet<Object>> entityLists = this.entitySetCollector.getRelatedIdentitySets(clazz);
        entityLists.forEach(entityList -> {
            entityList.remove(objectToRemove);
            this.storageManager.store(entityList.getInternalMap());
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleted single entity of class {}.", (Object)clazz.getSimpleName());
        }
    }

    public synchronized <T> void deleteAll(Class<T> clazz) {
        this.ensureEntitiesInRoot();
        IdentitySet<Object> entities = this.root.getEntityLists().get(this.getEntityName(clazz));
        int oldSize = entities.size();
        List entitiesToRemove = entities.stream().toList();
        List<IdentitySet<Object>> entityLists = this.entitySetCollector.getRelatedIdentitySets(clazz);
        entityLists.forEach(entityList -> {
            entityList.removeAll(entitiesToRemove);
            this.storageManager.store(entityList.getInternalMap());
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleted {} entities of class {}.", (Object)oldSize, (Object)clazz.getSimpleName());
        }
    }

    public synchronized void clearData() {
        this.root = new Root();
        StorageManager instanceOfstorageManager = this.getInstanceOfStorageManager();
        this.initRoot();
        instanceOfstorageManager.setRoot((Object)this.root);
        instanceOfstorageManager.storeRoot();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleared all entities.");
        }
    }

    public synchronized void stop() {
        LOG.info("Stopping storage...");
        if (this.storageManager != null) {
            this.storageManager.shutdown();
            this.storageManager = null;
            this.root = null;
            this.registry.reset();
            this.entityClassToIdSetter.clear();
            LOG.info("Stopped storage.");
        } else {
            LOG.info("No storage is running. Nothing to stop.");
        }
    }

    @Override
    public <T> IdSetter<T> ensureIdSetter(Class<T> domainClass) {
        return this.entityClassToIdSetter.computeIfAbsent(domainClass, clazz -> {
            String entityName = this.getEntityName(domainClass);
            Consumer<Object> idSetter = id -> {
                this.ensureEntitiesInRoot();
                this.root.getLastIds().put(entityName, id);
                this.storageManager.store(this.root.getLastIds());
            };
            Supplier<Object> idGetter = () -> {
                this.ensureEntitiesInRoot();
                return this.root.getLastIds().get(entityName);
            };
            return IdSetter.createIdSetter(domainClass, idSetter, idGetter);
        });
    }

    @Override
    public boolean isPersistable(Class<?> clazz) {
        this.ensureEntitiesInRoot();
        return this.persistenceChecker.isPersistable(clazz);
    }
}

