/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.migrater;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import software.xdev.micromigration.migrater.AbstractMigrater;
import software.xdev.micromigration.migrater.ScriptInstantiationException;
import software.xdev.micromigration.scripts.VersionAgnosticMigrationScript;

public class ReflectiveMigrater
extends AbstractMigrater {
    private final TreeSet<VersionAgnosticMigrationScript<?, ?>> sortedScripts = new TreeSet(VersionAgnosticMigrationScript.COMPARATOR);

    public ReflectiveMigrater(String packagePath) throws ScriptInstantiationException {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packagePath, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner()}).filterInputsBy((Predicate)new FilterBuilder().includePackage(packagePath)));
        for (Class scriptClass : reflections.getSubTypesOf(VersionAgnosticMigrationScript.class)) {
            if (Modifier.isAbstract(scriptClass.getModifiers())) continue;
            VersionAgnosticMigrationScript<?, ?> instanciatedScript = this.instanciateClass(scriptClass);
            this.checkIfVersionIsAlreadyRegistered(instanciatedScript);
            this.sortedScripts.add(instanciatedScript);
        }
    }

    private VersionAgnosticMigrationScript<?, ?> instanciateClass(Class<? extends VersionAgnosticMigrationScript> scriptClass) throws ScriptInstantiationException {
        try {
            return scriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ScriptInstantiationException("Could not instanciate class " + scriptClass.getName(), e);
        }
    }

    public TreeSet<VersionAgnosticMigrationScript<?, ?>> getSortedScripts() {
        return this.sortedScripts;
    }
}

