/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.microstream;

import java.nio.file.Path;
import java.util.Objects;
import one.microstream.afs.nio.types.NioFileSystem;
import one.microstream.afs.types.AFileSystem;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageLiveFileProvider;
import software.xdev.micromigration.microstream.MigrationEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;

public class MigrationEmbeddedStorage {
    public static final MigrationEmbeddedStorageManager start(MicroMigrater migrater) {
        Objects.requireNonNull(migrater);
        return (MigrationEmbeddedStorageManager)((Object)new MigrationEmbeddedStorageManager(MigrationEmbeddedStorage.createStorageManager(), migrater).start());
    }

    public static final MigrationEmbeddedStorageManager start(Path storageDirectory, MicroMigrater migrater) {
        Objects.requireNonNull(migrater);
        Objects.requireNonNull(storageDirectory);
        return (MigrationEmbeddedStorageManager)((Object)new MigrationEmbeddedStorageManager(MigrationEmbeddedStorage.createStorageManager(storageDirectory), migrater).start());
    }

    private static EmbeddedStorageManager createStorageManager(Path storageDirectory) {
        NioFileSystem fileSystem = NioFileSystem.New();
        return ((EmbeddedStorageFoundation)EmbeddedStorageFoundation.New().setConfiguration(StorageConfiguration.Builder().setStorageFileProvider(((StorageLiveFileProvider.Builder)Storage.FileProviderBuilder((AFileSystem)fileSystem).setDirectory(fileSystem.ensureDirectoryPath(new String[]{storageDirectory.toAbsolutePath().toString()}))).createFileProvider()).createConfiguration())).createEmbeddedStorageManager();
    }

    private static EmbeddedStorageManager createStorageManager() {
        return ((EmbeddedStorageFoundation)EmbeddedStorageFoundation.New().setConfiguration(StorageConfiguration.Builder().createConfiguration())).createEmbeddedStorageManager();
    }
}

