/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.eclipse.store;

import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.serializer.afs.types.AFileSystem;
import org.eclipse.store.afs.nio.types.NioFileSystem;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageManager;
import org.eclipse.store.storage.types.Storage;
import org.eclipse.store.storage.types.StorageConfiguration;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import software.xdev.micromigration.eclipse.store.MigrationEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;

public class MigrationEmbeddedStorage {
    public static final MigrationEmbeddedStorageManager start(MicroMigrater migrater) {
        Objects.requireNonNull(migrater);
        return (MigrationEmbeddedStorageManager)((Object)new MigrationEmbeddedStorageManager(MigrationEmbeddedStorage.createStorageManager(), migrater).start());
    }

    public static final MigrationEmbeddedStorageManager start(Path storageDirectory, MicroMigrater migrater) {
        Objects.requireNonNull(migrater);
        Objects.requireNonNull(storageDirectory);
        return (MigrationEmbeddedStorageManager)((Object)new MigrationEmbeddedStorageManager(MigrationEmbeddedStorage.createStorageManager(storageDirectory), migrater).start());
    }

    private static EmbeddedStorageManager createStorageManager(Path storageDirectory) {
        NioFileSystem fileSystem = NioFileSystem.New();
        return ((EmbeddedStorageFoundation)EmbeddedStorageFoundation.New().setConfiguration(StorageConfiguration.Builder().setStorageFileProvider(((StorageLiveFileProvider.Builder)Storage.FileProviderBuilder((AFileSystem)fileSystem).setDirectory(fileSystem.ensureDirectoryPath(new String[]{storageDirectory.toAbsolutePath().toString()}))).createFileProvider()).createConfiguration())).createEmbeddedStorageManager();
    }

    private static EmbeddedStorageManager createStorageManager() {
        return ((EmbeddedStorageFoundation)EmbeddedStorageFoundation.New().setConfiguration(StorageConfiguration.Builder().createConfiguration())).createEmbeddedStorageManager();
    }
}

