/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.scripts;

import java.util.ArrayList;
import software.xdev.micromigration.microstream.versionagnostic.VersionAgnosticMigrationEmbeddedStorageManager;
import software.xdev.micromigration.scripts.VersionAgnosticMigrationScript;
import software.xdev.micromigration.version.MigrationVersion;

public abstract class ReflectiveVersionMigrationScript<T, E extends VersionAgnosticMigrationEmbeddedStorageManager<?, ?>>
implements VersionAgnosticMigrationScript<T, E> {
    private static final char PREFIX = 'v';
    private static final String VERSION_SEPERATOR = "_";
    private static final String WRONG_FORMAT_ERROR_MESSAGE = "Script has invalid class name. Either rename the class to a valid script class name, or implement method getTargetVersion().";
    private final MigrationVersion version = this.createTargetVersionFromClassName();

    private MigrationVersion createTargetVersionFromClassName() {
        String implementationClassName = this.getClass().getSimpleName();
        if ('v' != implementationClassName.charAt(0)) {
            throw new Error(WRONG_FORMAT_ERROR_MESSAGE);
        }
        String implementationClassNameWithoutPrefix = implementationClassName.substring(1);
        String[] classNameParts = implementationClassNameWithoutPrefix.split(VERSION_SEPERATOR);
        if (classNameParts.length < 2) {
            throw new Error(WRONG_FORMAT_ERROR_MESSAGE);
        }
        try {
            ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
            for (int i = 0; i < classNameParts.length - 1; ++i) {
                versionNumbers.add(Integer.parseInt(classNameParts[i]));
            }
            return new MigrationVersion(versionNumbers);
        }
        catch (NumberFormatException e) {
            throw new Error(WRONG_FORMAT_ERROR_MESSAGE);
        }
    }

    @Override
    public MigrationVersion getTargetVersion() {
        return this.version;
    }
}

