/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.version;

import java.util.Objects;
import software.xdev.micromigration.version.MigrationVersion;
import software.xdev.micromigration.version.Versioned;

public class VersionedObject<T>
implements Versioned {
    private MigrationVersion currentVersion;
    private T actualObject;

    public VersionedObject(T actualObject) {
        this.actualObject = actualObject;
        this.currentVersion = new MigrationVersion(0);
    }

    @Override
    public void setVersion(MigrationVersion version) {
        Objects.requireNonNull(version);
        this.currentVersion = version;
    }

    @Override
    public MigrationVersion getVersion() {
        return this.currentVersion;
    }

    public void setObject(T actualObject) {
        this.actualObject = actualObject;
    }

    public T getObject() {
        return this.actualObject;
    }

    public String toString() {
        return this.currentVersion.toString() + "\n" + this.actualObject;
    }
}

