/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.version;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MigrationVersion {
    private final int[] versions;
    public static Comparator<MigrationVersion> COMPARATOR = new Comparator<MigrationVersion>(){

        @Override
        public int compare(MigrationVersion o1, MigrationVersion o2) {
            return Arrays.compare(o1.versions, o2.versions);
        }
    };

    public MigrationVersion(int ... versions) {
        this.versions = versions == null || versions.length == 0 ? new int[]{0} : versions;
    }

    public MigrationVersion(List<Integer> versionsAsList) {
        if (versionsAsList == null || versionsAsList.size() == 0) {
            this.versions = new int[]{0};
        } else {
            int[] versionsAsArray = new int[versionsAsList.size()];
            for (int i = 0; i < versionsAsArray.length; ++i) {
                versionsAsArray[i] = versionsAsList.get(i);
            }
            this.versions = versionsAsArray;
        }
    }

    public int[] getVersions() {
        return this.versions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("v");
        for (int version : this.versions) {
            sb.append(version).append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.versions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MigrationVersion other = (MigrationVersion)obj;
        return Arrays.equals(this.versions, other.versions);
    }
}

