/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.migrater;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import software.xdev.micromigration.microstream.versionagnostic.VersionAgnosticEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;
import software.xdev.micromigration.migrater.VersionAlreadyRegisteredException;
import software.xdev.micromigration.notification.ScriptExecutionNotification;
import software.xdev.micromigration.scripts.Context;
import software.xdev.micromigration.scripts.MigrationScript;
import software.xdev.micromigration.version.MigrationVersion;

public abstract class AbstractMigrater
implements MicroMigrater {
    private Consumer<ScriptExecutionNotification> notificationConsumer = null;

    public void setNotificationConsumer(Consumer<ScriptExecutionNotification> notificationConsumer) {
        this.notificationConsumer = notificationConsumer;
    }

    @Override
    public MigrationVersion migrateToNewest(MigrationVersion fromVersion, VersionAgnosticEmbeddedStorageManager storageManager, Object root) {
        Objects.requireNonNull(fromVersion);
        Objects.requireNonNull(storageManager);
        TreeSet<MigrationScript<?, ?>> sortedScripts = this.getSortedScripts();
        if (sortedScripts.size() > 0) {
            return this.migrateToVersion(fromVersion, this.getSortedScripts().last().getTargetVersion(), storageManager, root);
        }
        return fromVersion;
    }

    @Override
    public MigrationVersion migrateToVersion(MigrationVersion fromVersion, MigrationVersion targetVersion, VersionAgnosticEmbeddedStorageManager storageManager, Object objectToMigrate) {
        Objects.requireNonNull(fromVersion);
        Objects.requireNonNull(targetVersion);
        Objects.requireNonNull(storageManager);
        MigrationVersion updateVersionWhichWasExecuted = fromVersion;
        for (MigrationScript<?, ?> script : this.getSortedScripts()) {
            if (MigrationVersion.COMPARATOR.compare(fromVersion, script.getTargetVersion()) >= 0 || MigrationVersion.COMPARATOR.compare(script.getTargetVersion(), targetVersion) > 0) continue;
            LocalDateTime startDate = null;
            MigrationVersion versionBeforeUpdate = updateVersionWhichWasExecuted;
            if (this.notificationConsumer != null) {
                startDate = LocalDateTime.now();
            }
            updateVersionWhichWasExecuted = this.migrateWithScript(script, storageManager, objectToMigrate);
            if (this.notificationConsumer == null) continue;
            this.notificationConsumer.accept(new ScriptExecutionNotification(script, versionBeforeUpdate, updateVersionWhichWasExecuted, startDate, LocalDateTime.now()));
        }
        return updateVersionWhichWasExecuted;
    }

    private <T, E> MigrationVersion migrateWithScript(MigrationScript<T, E> script, VersionAgnosticEmbeddedStorageManager storageManager, Object objectToMigrate) {
        Object castedObjectToMigrate = objectToMigrate;
        script.migrate(new Context(castedObjectToMigrate, storageManager));
        return script.getTargetVersion();
    }

    protected void checkIfVersionIsAlreadyRegistered(MigrationScript<?, ?> scriptToCheck) {
        for (MigrationScript<?, ?> alreadyRegisteredScript : this.getSortedScripts()) {
            if (MigrationVersion.COMPARATOR.compare(alreadyRegisteredScript.getTargetVersion(), scriptToCheck.getTargetVersion()) != 0) continue;
            throw new VersionAlreadyRegisteredException(alreadyRegisteredScript.getTargetVersion(), alreadyRegisteredScript, scriptToCheck);
        }
    }
}

